local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local cv = require "computervisionfunction"


local HandEstimates = venuscore.VenusBehavior:extend("HandEstimates");

local hand_actions = 
{
  "HandOK",
  "HandScissor",
  "HandGood",
  "HandPalm",
  "HandPistol",
  "HandLove",
  "HandHoldup",
  "HandCongrats",
  "HandFingerHeart",
  "HandTwoIndexFinger",
  "HandFingerIndex",
  "HandFist",
  "Hand666",
  "HandBless"
}

function HandEstimates:new()
    self.trackid =1;
    self.action = "HandOK"
    self.face = false;
end

function HandEstimates:GetTrackId()
    return  self.trackid;
end

function HandEstimates:SetTrackId(rec)    
    self.trackid = rec;
end

function HandEstimates:_Play()

end

function HandEstimates:_OnAwake()
  if self.transform==nil then
    self.transform = self.Node:GetComponent(apolloengine.Node.CT_TRANSFORM);
    if self.transform==nil then
      LOG("WE HAVE NO TRANSFORM COMPOENENT!")
    end
  end
end

function HandEstimates:_OnStart()
  
end

function HandEstimates:GetProperties()
    return
    {
      "face",
      "EyeBlink",
      "MouthOpen",
      "HeadYaw",
      "HeadPitch",
      "BrowJump",
      "HandOK",
      "HandScissor",
      "HandGood",
      "HandPalm",
      "HandPistol",
      "HandLove",
      "HandHoldup",
      "HandCongrats",
      "HandFingerHeart",
      "HandTwoIndexFinger",
      "HandFingerIndex",
      "HandFist",
      "Hand666",
      "HandBless",
    };
end

function HandEstimates:GetScriptPropValue(prop)
    return self[prop]
end

function HandEstimates:SetScriptPropValue(prop, value)
    self[prop] = value
end

local function _toRelativeCoordinates(pixel_x, pixel_y, res)
  return pixel_x / res.mx * 2 - 1, 1 - pixel_y / res.my * 2;
end

local function _toLength(pixel_x, pixel_y, res)
  local x, y = pixel_x / res.mx, pixel_y / res.my;
  return math.sqrt(x*x+y*y);
end

function HandEstimates:_OnUpdate(timespan)
    local scriptProps = self:GetProperties()
    for _, prop in ipairs(scriptProps) do
        self[prop] = false
    end
    if self.classify and self.camera and self.transform then
      local classifyResult = self.classify:GetResultById(self.trackid);
      for _, action in ipairs(classifyResult) do
        if action.ActionName == self.action then
          self.face = true;
          local res = self.camera:GetCameraResolution();
          local cx = action.Rect[1] + action.Rect[3] * 0.5
          local cy = action.Rect[2] + action.Rect[4] * 0.5
          cx, cy = _toRelativeCoordinates(cx, cy, res);
          local center = mathfunction.vector2(cx, cy);
          local ray = self.camera:PickRay(center);
          local len = _toLength(action.Rect[3], action.Rect[4], res);
          local len_inv = 0.3 / len;
          local wpos = ray:GetOrigin() + ray:GetDirection() * len_inv;
          self.transform:SetLocalPosition(wpos);
        end
      end
    end
end

HandEstimates:MemberRegister("camera",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.CameraComponent:RTTI())); 

HandEstimates:MemberRegister(
    "classify",
    venuscore.ScriptTypes.ReferenceType(
        cv.ClassifyComponent:RTTI()
    )
);

HandEstimates:MemberRegister("trackid",  
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "1",
        value = 1
      },
      {
        key = "2",
        value = 2
      },
      {
        key = "3",
        value = 3
      },
    },
    HandEstimates.GetTrackId,
    HandEstimates.SetTrackId
  ));

local actionCombo = {}
for _, an in ipairs(hand_actions) do
  table.insert(actionCombo, {key = an, value = an});
end

HandEstimates:MemberRegister("action",  
  venuscore.ScriptTypes.ComboType(actionCombo));

return HandEstimates;