local Object        = require "classic"
local venuscore     = require "venuscore"
local venusjson     = require "venusjson"
local libmasquerade = require "libmasque"
local apolloengine  = require "apollocore"
local utils         = require "behavior.cartoon_behavior.utils"

local EmbedDeformation = venuscore.VenusBehavior:extend("EmbedDeformationBehavior")

function EmbedDeformation:new()
  EmbedDeformation.super.new(self)
  self.Config = ""
  self.BsMatchConfig = ""
  self.Inited = false
  self.mesh_deformation = libmasquerade.MeshDeformation()
end

function EmbedDeformation:Clear()
  self.mesh_deformation = nil
end

function EmbedDeformation:_OnAwake()
  self.morphComp = self.Node:GetComponent(apolloengine.Node.CT_MORPH)
  if (self.FaceNode ~= nil) then
    local faceTransfer = utils:GetBehavior(self.FaceNode, "facetransfer")
    if faceTransfer then
      faceTransfer:RegisterFaceTransferedEvent(self, self._OnTransferFinished)
    end
  end
end

function EmbedDeformation:_OnTransferFinished(vertexData, channelVertexData)
  
  if vertexData == nil or channelVertexData == nil then
    return
  end
  
  local bs_match = {}
  local bsMatchConfig = venusjson.LaodJsonFile(self.BsMatchConfig)
  if bsMatchConfig ~= nil then
    for k, v in pairs(bsMatchConfig) do
      bs_match[k] = v
    end
  else
    for i = 0, self.morphComp:GetNumberOfChannels(0) - 1 do
      local name = self.morphComp:GetChannelName(0, i)
      bs_match[name] = name
    end
  end

  self.mesh_deformation:EmbededDeform(vertexData, channelVertexData, self.morphComp, bs_match, venuscore.IFileSystem:PathAssembly(self.Config))
end


function EmbedDeformation:_OnUpdate(delta)

end

EmbedDeformation:MemberRegister("Config",  
  venuscore.ScriptTypes.FilePathType(
    {"json"}))

EmbedDeformation:MemberRegister("BsMatchConfig",  
  venuscore.ScriptTypes.FilePathType(
    {"json"}))

EmbedDeformation:MemberRegister("FaceNode",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()))

return EmbedDeformation