local apolloengine = require "apolloengine"

-- ü
local ai_makeup_refobj = { refcnt = 0 };

function ai_makeup_refobj:new(_scene, _refobj, obj)
  obj = obj or {};
  setmetatable(obj, self);
  self.__index = self;
  obj.scene = _scene;
  obj.refobj = _refobj;
  obj.refcnt = 0;
  return obj
end

function ai_makeup_refobj:GetReference()
  if self.refobj == nil then
    return nil
  end
  self.refcnt = self.refcnt + 1;
end

function ai_makeup_refobj:ReleaseReference()
  if self.refobj == nil then
    return nil
  end
  self.refcnt = self.refcnt - 1;
  if self.refcnt <= 0 then
    self.scene:DeleteNode(self.refobj);
    self.refcnt = 0;
    return true
  end
  return false;
end

function ai_makeup_refobj:GetRefObj()
  return self.refobj;
end

return ai_makeup_refobj;