require "venusdebug"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local beautydefined
local beautyutils = require "beauty.utils"

local LipScale = {}

function LipScale:_Switch(on)
	-- venus editor on/off facial effect's switch
	self.on = on;
	if self.on then
		self.coef = self.coef_temp;
	else
		self.coef = 0;
	end
end

function LipScale:_SetTempCoef(coef)
	-- venus editor temporary params value, used when switched on
	self.coef_temp = coef;
	if self.on then
		self.coef = self.coef_temp;
	end  
end

function LipScale:_InitParams(defined)
  beautydefined = defined
  --嘴型参数
  self.coef = self.coef or 0
  self.coef_temp = 1.0;
  -- shader params
  apolloengine.ShaderEntity.MOUTHTRIANGLEPOINTSOUECE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MOUTHTRIANGLEPOINTSOUECE");
  apolloengine.ShaderEntity.MOUTHTRIANGLEPOINTTARGET = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MOUTHTRIANGLEPOINTTARGET");
  apolloengine.ShaderEntity.MOUTHTRIANGLES = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MOUTHTRIANGLES");
  apolloengine.ShaderEntity.UNIFORM_LIPCOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_LIPCOEF");

end

function LipScale:SetParams(config, shaderParams)
  shaderParams.mouthTriangleSource = mathfunction.vector2array();
  shaderParams.mouthTriangleTarget = mathfunction.vector2array();
end

function LipScale:_InitQuad(quadnode, shaderParams)
  local mouthTriangles = mathfunction.vector3array();
  quadnode:SetParameter(apolloengine.ShaderEntity.MOUTHTRIANGLEPOINTSOUECE, shaderParams.mouthTriangleSource);
  quadnode:SetParameter(apolloengine.ShaderEntity.MOUTHTRIANGLEPOINTTARGET, shaderParams.mouthTriangleTarget);
  quadnode:SetParameter(apolloengine.ShaderEntity.MOUTHTRIANGLES, mouthTriangles);
  quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_LIPCOEF, mathfunction.vector1(0.0));
end

function LipScale:_UpdateTriPoint(quadnode, keypoints, config, rate)
  local coef = self.coef * rate
 
  local mouthTriangles = mathfunction.vector3array();
  for i = 1, #beautydefined.MouthTriangles / 3, 1 do
    local cur_tri = mathfunction.vector3(beautydefined.MouthTriangles[i * 3 - 2], beautydefined.MouthTriangles[i * 3 - 1], beautydefined.MouthTriangles[i * 3]);
    mouthTriangles:PushBack(cur_tri);
  end

  self.mouthTriangleSource = mathfunction.vector2array();
  self.mouthTriangleTarget = mathfunction.vector2array();

  local lip_vectory = {keypoints[beautydefined.MouthUpOuterMid + 1][1] - keypoints[beautydefined.MouthUpInnerMid + 1][1],
  keypoints[beautydefined.MouthUpOuterMid + 1][2] - keypoints[beautydefined.MouthUpInnerMid + 1][2]};

  local lip_vectorx = {keypoints[beautydefined.MouthIndices[3] + 1][1] - keypoints[beautydefined.MouthIndices[4] + 1][1],
  keypoints[beautydefined.MouthIndices[3] + 1][2] - keypoints[beautydefined.MouthIndices[4] + 1][2]};

  local mouth_center = {0, 0};
  for i = 1, #beautydefined.MouthIndices, 1 do
    mouth_center[1] = mouth_center[1] + keypoints[beautydefined.MouthIndices[i] + 1][1];
    mouth_center[2] = mouth_center[2] + keypoints[beautydefined.MouthIndices[i] + 1][2];
  end
  mouth_center[1] = mouth_center[1] / #beautydefined.MouthIndices;
  mouth_center[2] = mouth_center[2] / #beautydefined.MouthIndices;

  for i = 3, #beautydefined.MouthIndices, 1 do
    local pointCur = keypoints[beautydefined.MouthIndices[i] + 1];
    local pointForSource = {pointCur[1], pointCur[2]};
    local pointForTarget = {pointCur[1], pointCur[2]};
    self.mouthTriangleSource:PushBack(beautyutils._ArrayToVec2(pointForSource));
    self.mouthTriangleTarget:PushBack(beautyutils._ArrayToVec2(pointForTarget));
  -- LOG(pointForSource[1] .. " " .. pointForSource[2] .. " " .. pointForTarget[1] .. " " .. pointForTarget[2]);
  end

  for i = 1, #beautydefined.MouthInnerIndices, 1 do
    local pointCur = keypoints[beautydefined.MouthInnerIndices[i] + 1];
    self.mouthTriangleSource:PushBack(beautyutils._ArrayToVec2(pointCur));
    self.mouthTriangleTarget:PushBack(beautyutils._ArrayToVec2(pointCur));
    -- LOG(pointCur[1] .. " " .. pointCur[2] .. " " .. pointCur[1] .. " " .. pointCur[2]);
  end

  -- LOG("config.LipParam: " .. config.LipParam[1] .. " " .. config.LipParam[2] .. " " .. config.LipParam[3]);
  local displace_weights_x = {config.LipParam[4], 0.5 * config.LipParam[4], 0, -0.5 * config.LipParam[4], -config.LipParam[4]};
  local displace_weights_y = {config.LipParam[4], 1, 1, 1, config.LipParam[4]};
  local enlarge_width = 1;

  for i = 1, #beautydefined.MouthUpIndices, 1 do
    local pointCur = {keypoints[beautydefined.MouthUpIndices[i] + 1][1], keypoints[beautydefined.MouthUpIndices[i] + 1][2]};
    pointCur[1] = pointCur[1] + enlarge_width * (pointCur[1] - mouth_center[1]) * config.OuterParam;
    pointCur[2] = pointCur[2] + enlarge_width * (pointCur[2] - mouth_center[2]) * config.OuterParam;
    self.mouthTriangleSource:PushBack(beautyutils._ArrayToVec2(pointCur));

    local pointForTarget = {pointCur[1], pointCur[2]};
    pointForTarget[1] = pointForTarget[1] + lip_vectory[1] * config.LipParam[2] * displace_weights_y[i] * coef;
    pointForTarget[2] = pointForTarget[2] + lip_vectory[2] * config.LipParam[2] * displace_weights_y[i] * coef;

    pointForTarget[1] = pointForTarget[1] + lip_vectorx[1] * config.LipParam[1] * displace_weights_x[i] * coef;
    pointForTarget[2] = pointForTarget[2] + lip_vectorx[2] * config.LipParam[1] * displace_weights_x[i] * coef;

    self.mouthTriangleTarget:PushBack(beautyutils._ArrayToVec2(pointForTarget));
    -- LOG(pointCur[1] .. " " .. pointCur[2] .. " " .. pointForTarget[1] .. " " .. pointForTarget[2]);

    local pointForOut = {0, 0};
    pointForOut[1] = pointForTarget[1] + (pointForTarget[1] - mouth_center[1]) * config.OuterParam;
    pointForOut[2] = pointForTarget[2] + (pointForTarget[2] - mouth_center[2]) * config.OuterParam;
    self.mouthTriangleSource:PushBack(beautyutils._ArrayToVec2(pointForOut));
    self.mouthTriangleTarget:PushBack(beautyutils._ArrayToVec2(pointForOut));
    -- LOG(pointForOut[1] .. " " .. pointForOut[2] .. " " .. pointForOut[1] .. " " .. pointForOut[2]);
  end

  displace_weights_x = {config.LipParam[5], 0.5 * config.LipParam[5], 0, -0.5 * config.LipParam[5], -config.LipParam[5]};
  displace_weights_y = {config.LipParam[5], 1, 1, 1, config.LipParam[5]};
  for i = 1, #beautydefined.MouthDownIndices, 1 do
    local pointCur = {keypoints[beautydefined.MouthDownIndices[i] + 1][1], keypoints[beautydefined.MouthDownIndices[i] + 1][2]};
    pointCur[1] = pointCur[1] + enlarge_width * (pointCur[1] - mouth_center[1]) * config.OuterParam;
    pointCur[2] = pointCur[2] + enlarge_width * (pointCur[2] - mouth_center[2]) * config.OuterParam;
    self.mouthTriangleSource:PushBack(beautyutils._ArrayToVec2(pointCur));

    local pointForTarget = {pointCur[1], pointCur[2]};
    pointForTarget[1] = pointForTarget[1] - lip_vectory[1] * config.LipParam[3] * displace_weights_y[i] * coef; -- this '-' because lower lip goes down
    pointForTarget[2] = pointForTarget[2] - lip_vectory[2] * config.LipParam[3] * displace_weights_y[i] * coef;
    
    pointForTarget[1] = pointForTarget[1] - lip_vectorx[1] * config.LipParam[1] * displace_weights_x[i] * coef; -- this '-' because lower lip is in opposite order with uppder lip
    pointForTarget[2] = pointForTarget[2] - lip_vectorx[2] * config.LipParam[1] * displace_weights_x[i] * coef;

    self.mouthTriangleTarget:PushBack(beautyutils._ArrayToVec2(pointForTarget));
    -- LOG(pointCur[1] .. " " .. pointCur[2] .. " " .. pointForTarget[1] .. " " .. pointForTarget[2]);

    local pointForOut = {keypoints[beautydefined.MouthDownIndices[i] + 1][1], keypoints[beautydefined.MouthDownIndices[i] + 1][2]};
    pointForOut[1] = pointForTarget[1] + (pointForTarget[1] - mouth_center[1]) * config.OuterParam;
    pointForOut[2] = pointForTarget[2] + (pointForTarget[2] - mouth_center[2]) * config.OuterParam;
    self.mouthTriangleSource:PushBack(beautyutils._ArrayToVec2(pointForOut));
    self.mouthTriangleTarget:PushBack(beautyutils._ArrayToVec2(pointForOut));
    -- LOG(pointForOut[1] .. " " .. pointForOut[2] .. " " .. pointForOut[1] .. " " .. pointForOut[2]);
  end
  -- LOG("sizes: " .. mouthTriangles:Size() .. " " .. self.mouthTriangleSource:Size() .. " " .. self.mouthTriangleTarget:Size());
  -- LOG("points output finish");
  quadnode:SetParameter(apolloengine.ShaderEntity.MOUTHTRIANGLES, mouthTriangles);
  quadnode:SetParameter(apolloengine.ShaderEntity.MOUTHTRIANGLEPOINTSOUECE, self.mouthTriangleSource);
  quadnode:SetParameter(apolloengine.ShaderEntity.MOUTHTRIANGLEPOINTTARGET, self.mouthTriangleTarget);
  quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_LIPCOEF, mathfunction.vector1(coef));
end

function LipScale:_DrawQuad(quadnode, keypoints, config, rate)
  self:_UpdateTriPoint(quadnode, keypoints, config,rate)
end

function LipScale:UpdateParaValue(quadnode, config, attribute, value, keypoints)
  if (attribute == "X") then
    LOG("config.LipParam x set to: " .. value);
    config.LipParam[1] = value;
  elseif (attribute == "YUP") then
    LOG("config.LipParam yup set to: " .. value);
    config.LipParam[2] = value;
  elseif (attribute == "YDOWN") then
    LOG("config.LipParam ydown set to: " .. value);
    config.LipParam[3] = value;
  elseif (attribute == "RUP") then
    LOG("config.LipParam RUP set to: " .. value);
    config.LipParam[4] = value;
  elseif (attribute == "RDOWN") then
    LOG("config.LipParam RDOWN set to: " .. value);
    config.LipParam[5] = value;
  end
  --self:_UpdateTriPoint(quadnode, keypoints, config, true)
end

function LipScale:UpdateCoeff(quadnode, value, config, keypoints)
  if(value == 1) then
    self.coef = 1.0;
  else
    self.coef = 0;
  end
  --self:_UpdateTriPoint(quadnode, keypoints, config, true)
  LOG("Lip Scale coef set to: " .. self.coef);
end

function LipScale:GetParams(config)
  return config.LipParam
end

function LipScale:SetCoef(coef)
  if coef == nil then
    coef = 0
  end
  self.coef = coef;
  --LOG("Lip Scale coef: " .. self.coef)
end

function LipScale:_getWarpedKeyPointsDisplacement(keypoints, keypointsDisplacement, config, rate)
  if self.coef == 0 then
    return;
  end
  local lip_vectory = {keypoints[beautydefined.MouthUpOuterMid + 1][1] - keypoints[beautydefined.MouthUpInnerMid + 1][1],
  keypoints[beautydefined.MouthUpOuterMid + 1][2] - keypoints[beautydefined.MouthUpInnerMid + 1][2]};

  local lip_vectorx = {keypoints[beautydefined.MouthIndices[3] + 1][1] - keypoints[beautydefined.MouthIndices[4] + 1][1],
  keypoints[beautydefined.MouthIndices[3] + 1][2] - keypoints[beautydefined.MouthIndices[4] + 1][2]};

  local coef = self.coef * rate
  
  local displace_weights_x = {config.LipParam[4], 0.5 * config.LipParam[4], 0, -0.5 * config.LipParam[4], -config.LipParam[4]};
  local displace_weights_y = {config.LipParam[4], 1, 1, 1, config.LipParam[4]};
  local adv_displace_weights_x = {
    displace_weights_x[1]/3, displace_weights_x[1]*2/3, displace_weights_x[1], 
    (displace_weights_x[1]*2+displace_weights_x[2])/3, (displace_weights_x[1]+displace_weights_x[2]*2)/3, displace_weights_x[2], 
    (displace_weights_x[2]+displace_weights_x[3])/2, displace_weights_x[3], (displace_weights_x[3]+displace_weights_x[4])/2, 
    displace_weights_x[4], (displace_weights_x[4]*2+displace_weights_x[5])/3, (displace_weights_x[4]+displace_weights_x[5]*2)/3, 
    displace_weights_x[5], displace_weights_x[5]*2/3, displace_weights_x[5]/3
  }
  local adv_displace_weights_y = {
    displace_weights_y[1]/3, displace_weights_y[1]*2/3, displace_weights_y[1], 
    (displace_weights_y[1]*2+displace_weights_y[2])/3, (displace_weights_y[1]+displace_weights_y[2]*2)/3, displace_weights_y[2], 
    (displace_weights_y[2]+displace_weights_y[3])/2, displace_weights_y[3], (displace_weights_y[3]+displace_weights_y[4])/2, 
    displace_weights_y[4], (displace_weights_y[4]*2+displace_weights_y[5])/3, (displace_weights_y[4]+displace_weights_y[5]*2)/3, 
    displace_weights_y[5], displace_weights_y[5]*2/3, displace_weights_y[5]/3
    }
  local uppoints = {}
  for i = 1, #beautydefined.MouthUpIndices do
    table.insert(uppoints, beautydefined.MouthUpIndices[i] + 1)
  end
  if #keypoints >= 240 then
    for i = 71, 85 do
      table.insert(uppoints, i + 106 + 1)
      table.insert(displace_weights_x, adv_displace_weights_x[i-70])
      table.insert(displace_weights_y, adv_displace_weights_y[i-70])
    end
  end
  for i = 1, #uppoints do
    local index = uppoints[i]
    keypointsDisplacement[index][1] = keypointsDisplacement[index][1] - lip_vectory[1] * config.LipParam[2] * coef * displace_weights_y[i]
    keypointsDisplacement[index][2] = keypointsDisplacement[index][2] - lip_vectory[2] * config.LipParam[2] * coef * displace_weights_y[i]
    keypointsDisplacement[index][1] = keypointsDisplacement[index][1] - lip_vectorx[1] * config.LipParam[1] * coef * displace_weights_x[i];
    keypointsDisplacement[index][2] = keypointsDisplacement[index][2] - lip_vectorx[2] * config.LipParam[1] * coef * displace_weights_x[i];
  end
  
  displace_weights_x = {config.LipParam[5], 0.5 * config.LipParam[5], 0, -0.5 * config.LipParam[5], -config.LipParam[5]};
  displace_weights_y = {config.LipParam[5], 1, 1, 1, config.LipParam[5]};
  adv_displace_weights_x = {
    displace_weights_x[1]/3, displace_weights_x[1]*2/3, displace_weights_x[1], 
    (displace_weights_x[1]*2+displace_weights_x[2])/3, (displace_weights_x[1]+displace_weights_x[2]*2)/3, displace_weights_x[2], 
    (displace_weights_x[2]+displace_weights_x[3])/2, displace_weights_x[3], (displace_weights_x[3]+displace_weights_x[4])/2, 
    displace_weights_x[4], (displace_weights_x[4]*2+displace_weights_x[5])/3, (displace_weights_x[4]+displace_weights_x[5]*2)/3, 
    displace_weights_x[5], displace_weights_x[5]*2/3, displace_weights_x[5]/3 
  }
  adv_displace_weights_y = {
    displace_weights_y[1]/3, displace_weights_y[1]*2/3, displace_weights_y[1], 
    (displace_weights_y[1]*2+displace_weights_y[2])/3, (displace_weights_y[1]+displace_weights_y[2]*2)/3, displace_weights_y[2], 
    (displace_weights_y[2]+displace_weights_y[3])/2, displace_weights_y[3], (displace_weights_y[3]+displace_weights_y[4])/2, 
    displace_weights_y[4], (displace_weights_y[4]*2+displace_weights_y[5])/3, (displace_weights_y[4]+displace_weights_y[5]*2)/3, 
    displace_weights_y[5], displace_weights_y[5]*2/3, displace_weights_y[5]/3
    }
  local downpoints = {}
  for i = 1, #beautydefined.MouthDownIndices do
    table.insert(downpoints, beautydefined.MouthDownIndices[i] + 1)
  end
  if #keypoints >= 240 then
    for i = 119, 133 do
      table.insert(downpoints, i + 106 + 1)
      table.insert(displace_weights_x, adv_displace_weights_x[i-118])
      table.insert(displace_weights_y, adv_displace_weights_y[i-118])
    end
  end
  for i = 1, #downpoints do
    local index = downpoints[i]
    keypointsDisplacement[index][1] = keypointsDisplacement[index][1] + lip_vectory[1] * config.LipParam[3] * coef * displace_weights_y[i]
    keypointsDisplacement[index][2] = keypointsDisplacement[index][2] + lip_vectory[2] * config.LipParam[3] * coef * displace_weights_y[i]
    keypointsDisplacement[index][1] = keypointsDisplacement[index][1] + lip_vectorx[1] * config.LipParam[1] * coef * displace_weights_x[i];
    keypointsDisplacement[index][2] = keypointsDisplacement[index][2] + lip_vectorx[2] * config.LipParam[1] * coef * displace_weights_x[i];
  end
end

function LipScale:Release()
end
  
return LipScale