local triggerdefined = require "videodecet.defined"
local videodecet = require "videodecet"
local soundplayer = require "soundplayer"
local b3 = require 'behavior3.b3';
require 'behavior3.core.Condition'
require "utility"

local volumeactioncached = b3.Class("VolumeActionCached", b3.Condition)

function volumeactioncached:ctor(properties, target)
  b3.Condition.ctor(self)
	self.name = "VolumeActionCached"
  self.volume = properties.volume;
end

function volumeactioncached:tick(tick)
  local volume = soundplayer.GetCachedVolume();
  if volume >= self.volume then
    return b3.SUCCESS;
  end
  return b3.FAILURE;
end

return volumeactioncached;