
#DEFPARAMS
HISTORICAL_FRAME1 = { "Frame Tex1", TEXTURE2D, "white" },
HISTORICAL_FRAME2 = { "Frame Tex2", TEXTURE2D, "white" },
HISTORICAL_FRAME3 = { "Frame Tex3", TEXTURE2D, "white" },
HISTORICAL_FRAME4 = { "Frame Tex4", TEXTURE2D, "white" },
NOISE_TEXTURE= { "Noise Tex", TEXTURE2D, "white" },
FRAME_SIZE = { "Frame size", FLOAT, "0.0" },
CUR_FRAME_ID = { "Current ID", FLOAT, "0.0" },
RESOLUTION = { "Resolution", VEC2, "0.0,0.0" },
SAMPLE_SIZE = { "Sample Size", VEC2, "0.0,0.0" },
HISTORICAL_FRAMES = { "Historical frames", FLOAT, "0.0" },
ROW_FRAME_NUM_PER_TEX = { "Row Frame number per Tex", FLOAT, "0.0" },
COL_FRAME_NUM_PER_TEX = { "Col Frame number per Tex", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "Dust"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D HISTORICAL_FRAME1;
Texture2D HISTORICAL_FRAME2;
Texture2D HISTORICAL_FRAME3;
Texture2D HISTORICAL_FRAME4;
Texture2D NOISE_TEXTURE;
SamplerState NOISE_Sampler;
SamplerState FRAME_Sampler1;
SamplerState FRAME_Sampler2;
SamplerState FRAME_Sampler3;
SamplerState FRAME_Sampler4;
float FRAME_SIZE;
float CUR_FRAME_ID;
float2 RESOLUTION;
float2 SAMPLE_SIZE;
float HISTORICAL_FRAMES;
float ROW_FRAME_NUM_PER_TEX;
float COL_FRAME_NUM_PER_TEX;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float customMod(float number, float denom)
{
  float tfactor = number / denom;
  float res = frac(tfactor) * denom;
  if(res < 0)
  {
    res += denom;
  }
  return res;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	  int iFrameSize = int(FRAME_SIZE);
    int iCurFrameID = int(CUR_FRAME_ID);
    int iRowFrameNumPerTex = int(ROW_FRAME_NUM_PER_TEX);
    int iColFrameNumPerTex = int(COL_FRAME_NUM_PER_TEX);

    float2 xy = i.uv * RESOLUTION;
    float2 uv = (floor(xy / SAMPLE_SIZE) * SAMPLE_SIZE) / RESOLUTION; 

    float r = NOISE_TEXTURE.Sample(NOISE_Sampler, uv).r;

    int minus_frames = int(r * HISTORICAL_FRAMES);
    int frame_id = int(customMod(iCurFrameID - minus_frames, iFrameSize));

    int FRAME_NUM_PER_TEX = iRowFrameNumPerTex * iColFrameNumPerTex;
    int tex_id = frame_id / FRAME_NUM_PER_TEX;
    int local_frame_id = int(customMod(frame_id, FRAME_NUM_PER_TEX));
    
    float x_scale = 1.0 / iRowFrameNumPerTex;
    float y_scale = 1.0 / iColFrameNumPerTex;        
    
    int divide = local_frame_id / iRowFrameNumPerTex;
    float tex_x_start = x_scale * customMod(local_frame_id, iRowFrameNumPerTex);
    float tex_y_start = y_scale * float(iColFrameNumPerTex - 1 - divide);

    float2 tex_pos = float2(tex_x_start, tex_y_start) + float2(x_scale, y_scale) * i.uv;

    float3 rgb = float3(0.0, 0.0, 0.0);
    if (tex_id == 0)
      rgb = HISTORICAL_FRAME1.Sample(FRAME_Sampler1, tex_pos).rgb;
    else if (tex_id == 1)
      rgb = HISTORICAL_FRAME2.Sample(FRAME_Sampler2, tex_pos).rgb;
    else if (tex_id == 2)
      rgb = HISTORICAL_FRAME3.Sample(FRAME_Sampler3, tex_pos).rgb;
    else if (tex_id == 3)
      rgb = HISTORICAL_FRAME4.Sample(FRAME_Sampler4, tex_pos).rgb;

    mainColor = float4(rgb, 1.0);
}
ENDCG
#END
