

#DEFPARAMS
#END

#DEFTAG
ShaderName = "DirBlur"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_uDab;
SamplerState uDab_Sampler;
float2 UNIFORM_uOs;
float UNIFORM_uHiu;
float UNIFORM_uVer;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float k = gauss(0.0, UNIFORM_uHiu);
    float sum = k;
    float4 vfs = TEXTURE_uDab.Sample(uDab_Sampler, UNIFORM_uVer);
    float3 result;
    //if (abs(uVer - 2.0) < 0.0001) {
        result = float3(decode(vfs), 0.0) * k;
   // }
    //else {
    //    result = vfs.xyz * k;
    //}

    for (int j = 1; j <= 3; ++j) {
        k = gauss(float(j), UNIFORM_uHiu);
        sum += k + k;
        float2 offset = float2(UNIFORM_uOs.x * float(j), 0.0);

        float4 qw0 = TEXTURE_uDab.Sample(uDab_Sampler, i.uv + offset);
        float4 qw1 = TEXTURE_uDab.Sample(uDab_Sampler, i.uv - offset);
        //if (abs(uVer - 2.0) < 0.0001) {
            result += float3(decode(qw0), 0.0) * k;
            result += float3(decode(qw1), 0.0) * k;
        //}
        //else {
        //    result += qw0.xyz * k;
         //   result += qw1.xyz * k;
        //}
    }
    result /= sum;

    //if (abs(uVer - 2.0) < 0.0001) {
        mainColor = encode(result.xy);
    //}
    //else {
    //    gl_FragColor = vec4(result, 0.);
    //}
 
}
ENDCG
#END
