
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
UNIFORM_TIME = { "Time", FLOAT, "1.0"},
UNIFORM_XYRATIO = { "XY Ratio", FLOAT, "1.0"},
UNIFORM_RADIUS = { "Radius", VEC3, "1.0,1.0,1.0"},
UNIFORM_WAVEWIDTH = { "Wave Width", FLOAT, "1.0"},
UNIFORM_DISFACTOR = { "Radius", VEC3, "1.0,1.0,1.0"},
UNIFORM_AMPFACTOR = { "Radius", VEC3, "1.0,1.0,1.0"},
#END

#DEFTAG
ShaderName = "Ripple"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float UNIFORM_TIME;
float UNIFORM_XYRATIO;
float2 UNIFORM_POINT[3];
float3 UNIFORM_RADIUS;
float UNIFORM_WAVEWIDTH;
float3 UNIFORM_DISFACTOR;
float3 UNIFORM_AMPFACTOR;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = float2(v.uv.x, v.uv.y);
	return o;
}

float2 getRippleOffset(float2 currentPoint, float2 center, float radius, float xyRatio, float disfactor, float time, float wavewidth, float ampfactor)
{
  float2 flipcenter = float2(center.x, 1.0 - center.y);
  float2 dir = flipcenter - currentPoint;
  dir = dir * float2(1.0, xyRatio);
  float dis = length(dir);
  float offset = sin(dis * disfactor + time) * ampfactor * clamp(1.0 - abs(radius * 1.5), 0.0, 1.0);
  float discardFactor = clamp(wavewidth - abs(radius - dis), 0.0, 1.0);
  dir = normalize(dir);
  
  return dir * offset * discardFactor;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 textureCoordinate = i.uv;
    float3 radius = UNIFORM_RADIUS;
    float xyRatio = UNIFORM_XYRATIO;
    float3 disfactor = UNIFORM_DISFACTOR;
    float time = UNIFORM_TIME;
    float wavewidth = UNIFORM_WAVEWIDTH;
    float3 ampfactor = UNIFORM_AMPFACTOR;
    float2 offset1 = getRippleOffset(textureCoordinate, UNIFORM_POINT[0], radius.x, xyRatio, disfactor.x, time, wavewidth, ampfactor.x);
    float2 offset2 = getRippleOffset(textureCoordinate, UNIFORM_POINT[1], radius.y, xyRatio, disfactor.y, time, wavewidth, ampfactor.y);
    float2 offset3 = getRippleOffset(textureCoordinate, UNIFORM_POINT[2], radius.z, xyRatio, disfactor.z, time, wavewidth, ampfactor.z);
    
    float2 newCoord = textureCoordinate + offset1 + offset2 + offset3;
    float3 rgb = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, newCoord).rgb;
    
    mainColor = float4(rgb, 1.0);
}
ENDCG
#END
