package sg.bigo.libvideo.cam.strategy.indexchoose;

import static java.lang.Math.atan;

import android.content.Context;
import android.hardware.Camera;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.util.SizeF;

import androidx.annotation.RequiresApi;

import sg.bigo.libvideo.cam.abs.Log;

@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
public class SamsungStrategy extends BaseStrategy {
    private static final String TAG = "SamsungStrategy";

    public SamsungStrategy(Context context, boolean isFrontCamera) {
        super(isFrontCamera);
        mContext = context;
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    @Override
    public int selectCameraIndex(boolean isFrontCamera) {
        mIsFrontCamera = isFrontCamera;
        if (mCameraIndexInited) {
            return getProperCameraIndex(mIsFrontCamera);
        }
        try {
            getBetterFrontCameraIndex();
            mCameraIndexInited = true;
        } catch (Exception e) {
            Log.e(TAG, "failed to get camera info", e);
        }
        return getProperCameraIndex(mIsFrontCamera);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    private void getBetterFrontCameraIndex() {
        double maxFOV = 0.d;
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo info = new Camera.CameraInfo();
        for (int i = 0; i < numberOfCameras; i++) {
            Camera.getCameraInfo(i, info);
            if (info.facing == Camera.CameraInfo.CAMERA_FACING_FRONT) {
                if (mFrontCameraIndex == -1) {
                    maxFOV = getDeviceFOV(i);
                    mFrontCameraIndex = i;
                } else if (getDeviceFOV(i) > maxFOV) {
                    maxFOV = getDeviceFOV(i);
                    mFrontCameraIndex = i;
                }
            } else if (info.facing == Camera.CameraInfo.CAMERA_FACING_BACK) {
                mBackCameraIndex = 0;
            }
        }
        Log.e(TAG, "mFrontCameraIndex:" + mFrontCameraIndex + " mBackCameraIndex:" + mBackCameraIndex);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    private double getDeviceFOV(int index) {
        if (null == mContext) {
            return 0.d;
        }
        try {
            CameraManager manager = (CameraManager) mContext.getSystemService(Context.CAMERA_SERVICE);
            String cameraId = manager.getCameraIdList()[index];
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
            SizeF sizeF = characteristics.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE);
            float[] focusLen = characteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
            // 对前摄来说是竖直方向
            double horizontalViewAngle = 2 * atan(sizeF.getWidth() / (2 * focusLen[0]));
            // 对前摄来说是水平方向
            double verticalViewAngle = 2 * atan(sizeF.getHeight() / (2 * focusLen[0]));
            Log.e(TAG, String.format("deviceIndex: %d horizontalViewAngle: %f verticalViewAngle: %f", index, horizontalViewAngle, verticalViewAngle));
            return horizontalViewAngle;
        } catch (CameraAccessException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0.d;
    }
}
