package sg.bigo.libvideo.cam.strategy.indexchoose;

import android.hardware.Camera;

import sg.bigo.libvideo.cam.abs.Log;

// 线上的 Index 选择策略：默认使用逻辑序号最大的设备，比如前摄存在 1、3，会选中 3；后摄存在 0、2，会选中 2
// 注意：一般 0，1 为 前，后主摄，2，3 为前后广角
// 但是在三星升级由 oneui 由 3.0 升级到 4.0 后，3号的 fov 比 1号小了
public class OriginStrategy extends BaseStrategy {
    private static final String TAG = "OriginStrategy";

    public OriginStrategy(boolean isFrontCamera) {
        super(isFrontCamera);
    }

    @Override
    public int selectCameraIndex(boolean isFrontCamera) {
        mIsFrontCamera = isFrontCamera;
        if (mCameraIndexInited) {
            return mIsFrontCamera ? mFrontCameraIndex : mBackCameraIndex;
        }
        try {
            int numberOfCameras = Camera.getNumberOfCameras();
            Camera.CameraInfo info = new Camera.CameraInfo();
            for (int i = 0; i < numberOfCameras; i++) {
                Camera.getCameraInfo(i, info);
                if (info.facing == Camera.CameraInfo.CAMERA_FACING_FRONT) {
                    mFrontCameraIndex = i;
                } else if (info.facing == Camera.CameraInfo.CAMERA_FACING_BACK) {
                    mBackCameraIndex = i;
                }
            }
            mCameraIndexInited = true;
        } catch (Exception e) {
            Log.e(TAG, "failed to get camera info", e);
        }

        Log.e(TAG, "selectCameraIndex mFrontCameraIndex:"
                + mFrontCameraIndex + "mBackCameraIndex:" + mBackCameraIndex);
        if (mFrontCameraIndex == -1 && mBackCameraIndex == -1) {
            return 0;
        }
        return mIsFrontCamera ? mFrontCameraIndex : mBackCameraIndex;
    }
}
