package sg.bigo.libvideo.cam.strategy.indexchoose;

import android.hardware.Camera;

import sg.bigo.libvideo.cam.abs.Log;
import sg.bigo.libvideo.cam.metering.CameraHelper;

// 默认的 Index 选择策略：存在前摄时，默认使用 index = 1 的主摄，存在后摄时，默认使用 index = 0 的主摄
public class DefaultStrategy extends BaseStrategy {
    private static final String TAG = "DefaultStrategy";

    public DefaultStrategy(boolean isFrontCamera) {
        super(isFrontCamera);
    }

    @Override
    public int selectCameraIndex(boolean isFrontCamera) {
        mIsFrontCamera = isFrontCamera;
        if (mCameraIndexInited) {
            return getProperCameraIndex(mIsFrontCamera);
        }
        try {
            mFrontCameraIndex = CameraHelper.getCameraCount(Camera.CameraInfo.CAMERA_FACING_FRONT) > 0
                    ? mMainFrontCameraIndex : -1;
            mBackCameraIndex = CameraHelper.getCameraCount(Camera.CameraInfo.CAMERA_FACING_BACK) > 0
                    ? mMainBackCameraIndex : -1;
            mCameraIndexInited = true;
        } catch (Exception e) {
            Log.e(TAG, "paradoxie:failed to get camera info", e);
        }
        Log.e(TAG, "selectCameraIndex mFrontCameraIndex:" + mFrontCameraIndex + "mBackCameraIndex:" + mBackCameraIndex);
        return getProperCameraIndex(mIsFrontCamera);
    }
}
