package sg.bigo.libvideo.cam.strategy.indexchoose;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;

import sg.bigo.libvideo.VcABConfig;
import sg.bigo.libvideo.cam.metering.CameraHelper;

public class CameraIndexChooseFactory {
    private static CameraChooseStrategy chooseStrategy = CameraChooseStrategy.SAMSUNG_FRONT_OPTIMIZE;
    private static BaseStrategy mStrategy;

    public static int createCameraChooseStategy(Context context, boolean isFrontCamera) {
        chooseStrategy = VcABConfig.getChooseStrategy();
        if (mStrategy != null) {
            return mStrategy.selectCameraIndex(isFrontCamera);
        }
        switch (chooseStrategy) {
            case SAMSUNG_FRONT_OPTIMIZE:{
                if (isSamsungSpecialCase() && null != context) {
                    mStrategy = new SamsungStrategy(context, isFrontCamera);
                    break;
                }
            }
            case DEFAUTL_CHOOSE_MAIN:
                mStrategy = new DefaultStrategy(isFrontCamera);
                break;
            case OLD_STRATEGY_ONLINE:
                mStrategy = new OriginStrategy(isFrontCamera);
                break;
            default:
                mStrategy = new DefaultStrategy(isFrontCamera);
        }
        return mStrategy.selectCameraIndex(isFrontCamera);
    }

    // 针对开启优化的，三星，前摄超过2个，支持 api2 的机型
    private static boolean isSamsungSpecialCase() {

        return Build.MANUFACTURER.equalsIgnoreCase("samsung")
                && CameraHelper.getCameraCount(Camera.CameraInfo.CAMERA_FACING_FRONT) > 1
                && Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP;

    }
}
