package sg.bigo.libvideo.cam.strategy.indexchoose;

import android.content.Context;
import android.hardware.Camera;

import sg.bigo.libvideo.cam.abs.Log;

public abstract class BaseStrategy implements VcCameraChooseStrategy {
    private static final String TAG = "BaseStrategy";
    protected Context mContext;
    protected boolean mCameraIndexInited = false;
    protected int mFrontCameraIndex = -1;
    protected int mBackCameraIndex = -1;
    protected int mMainFrontCameraIndex = -1;
    protected int mMainBackCameraIndex = -1;
    // 兜底策略使用，前摄默认为 index = 1， 后摄默认为 index = 0；
    protected int mDefaultFrontCameraIndex = 1;
    protected int mDefaultBackCameraIndex = 0;
    protected boolean mIsFrontCamera;


    public BaseStrategy(boolean isFrontCamera) {
        mIsFrontCamera = isFrontCamera;
        initMainCameraDevice();
    }

    // 初始化前后相机主摄 index
    protected void initMainCameraDevice() {
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo info = new Camera.CameraInfo();
        for (int i = 0; i < numberOfCameras; i++) {
            Camera.getCameraInfo(i, info);
            if (info.facing == Camera.CameraInfo.CAMERA_FACING_FRONT) {
                if (mMainFrontCameraIndex == -1) {
                    mMainFrontCameraIndex = i;
                }
            } else if (info.facing == Camera.CameraInfo.CAMERA_FACING_BACK) {
                if (mMainBackCameraIndex == -1) {
                    mMainBackCameraIndex = i;
                }
            }
        }
        Log.e(TAG, "initMainCameraDevice mMainFrontCameraIndex:"
                + mMainFrontCameraIndex + " mMainBackCameraIndex:" + mMainBackCameraIndex);
    }

    // 返回合适的相机 index，包含兜底策略
    protected int getProperCameraIndex(boolean isFrontCamera) {
        Log.e(TAG, "[getProperCameraIndex]mFrontCameraIndex:"
                + mFrontCameraIndex + " mBackCameraIndex:" + mBackCameraIndex);
        if (isFrontCamera) {
            if (mFrontCameraIndex != -1) {
                return mFrontCameraIndex;
            }
            return mBackCameraIndex == -1 ? mDefaultBackCameraIndex : mBackCameraIndex;
        } else {
            if (mBackCameraIndex != -1) {
                return mBackCameraIndex;
            }
            return mFrontCameraIndex == -1 ? mDefaultFrontCameraIndex : mFrontCameraIndex;
        }
    }

}
