package sg.bigo.libvideo.cam.runtime;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public class VcFrameStory {

    class MileStone {
        public long time = 0;
        public String desc = null;
        public VcProvenance runtime = VcProvenance.Unknown;

        public void reset() {
            time = 0;
            desc = null;
            runtime = VcProvenance.Unknown;
        }

        public boolean hasData() {
            return time != 0 || desc != null || runtime != VcProvenance.Unknown;
        }
    }

    private long mFrameIndex;
    private LinkedList<MileStone> mMilestones = new LinkedList<>();
    private StringBuilder mStories;

    public VcFrameStory() {
    }

    public MileStone mileStone(long frameIndex, VcProvenance runtime, String eventDesc) {
        if (mFrameIndex == 0) {
            mFrameIndex = frameIndex;
        } else if (mFrameIndex != frameIndex) {
            return null;
        }
        MileStone mileStone = null;
        Iterator<MileStone> iterator = mMilestones.iterator();
        while (iterator.hasNext()) {
            MileStone temp = iterator.next();
            if (temp != null && !temp.hasData()) {
                mileStone = temp;
                break;
            }
        }
        if (mileStone == null) {
            mileStone = new MileStone();
            mMilestones.push(mileStone);
        }
        mileStone.time = System.currentTimeMillis();
        mileStone.runtime = runtime;
        mileStone.desc = eventDesc;
        return mileStone;
    }

    public VcFrameStory event(String eventDesc) {
        if (eventDesc != null) {
            if (mStories == null) {
                mStories = new StringBuilder();
            }
            mStories.append(eventDesc);
            mStories.append(";");
        }
        return this;
    }

    public String readStory() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{[id:");
        stringBuilder.append(mFrameIndex);
        stringBuilder.append("];");
        long start = 0;
        long cost = 0;
        Iterator<MileStone> it = mMilestones.iterator();
        SimpleDateFormat sdf = null;
        while (it.hasNext()) {
            MileStone mileStone = it.next();
            if (mileStone.hasData()) {
                if (start == 0) {
                    start = mileStone.time;
                } else if (mileStone.time - start > cost) {
                    cost = mileStone.time - start;
                }
                stringBuilder.append("[");
                stringBuilder.append(mileStone.runtime.name().substring(0, 1));
                stringBuilder.append("_");
                stringBuilder.append(mileStone.desc);
                stringBuilder.append(",");
                if (sdf == null) {
                    sdf = new SimpleDateFormat("mm:ss.SSS");
                }
                stringBuilder.append(sdf.format(new Date(mileStone.time)));
                stringBuilder.append("];");
            }
        }
        stringBuilder.append("[cost:");
        stringBuilder.append(cost);
        stringBuilder.append("];");
        stringBuilder.append(mStories == null ? "null" : mStories);
        stringBuilder.append("}\n\r");
        return stringBuilder.toString();
    }

    public void clear() {
        mFrameIndex = 0;
        mStories = null;
        if (!mMilestones.isEmpty()) {
            for (MileStone mileStone : mMilestones) {
                mileStone.reset();
            }
        }
    }
}
