package sg.bigo.libvideo.cam.runtime;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sg.bigo.libvideo.cam.abs.Log;

import sg.bigo.libvideo.cam.abs.Log;

public class VcFpsContext {
    private final String TAG = "VcFpsController";

    private final int mControl_fps = 30;
    private int mFps = 30;
    private int mDropInterval = 0;
    private long mFrameIndex;
    private ReadWriteLock mLock = new ReentrantReadWriteLock();

    public void decreaseFps() {
        mLock.writeLock().lock();
        try {
            if (mFps > 0) {
                mFps--;
                if (VcRuntime.instance().enableFrameStory) {
                    Log.e(TAG, "decreaseFps:" + mFps);
                }
                calcDropInterval();
            }
        } finally {
            mLock.writeLock().unlock();
        }
    }

    public void increaseFps() {
        mLock.writeLock().lock();
        try {
            if (mFps < 30) {
                mFps++;
                if (VcRuntime.instance().enableFrameStory) {
                    Log.e(TAG, "increaseFps:" + mFps);
                }
                calcDropInterval();
            }
        } finally {
            mLock.writeLock().unlock();
        }
    }

    private void calcDropInterval() {
        int offset = mControl_fps - mFps;
        if (offset > 0) {
            mDropInterval = (int) (1.0f * mControl_fps / offset);
        }
    }

    public boolean needDropFrame() {
        mLock.readLock().lock();
        try {
            mFrameIndex++;
            boolean drop = mDropInterval > 0 && mDropInterval < 30 && mFrameIndex % mDropInterval == 0;
            if (drop && VcRuntime.instance().enableFrameStory) {
                Log.e(TAG, "drop Frame when fps=" + mFps + ";dropInterval:" + mDropInterval + ";frameIndex:" + mFrameIndex);
            }
            return drop;
        } finally {
            mLock.readLock().unlock();
        }
    }

    public void clear() {
        mLock.writeLock().lock();
        try {
            mFrameIndex = 0;
            mFps = 30;
            mDropInterval = 0;
        } finally {
            mLock.writeLock().unlock();
        }
    }

    public int getCurrentFps() {
        mLock.readLock().lock();
        try {
            return mFps - mControl_fps;
        } finally {
            mLock.readLock().unlock();
        }
    }
}
