package sg.bigo.libvideo.cam.metering;

import android.graphics.Point;
import android.graphics.Rect;

/**
 * @author wilbert
 * @Date 2020/12/22 18:33
 * @email jiangwang.wilbert@bigo.sg
 **/
public class MeteringController implements IMetering {

    private static final String TAG = "MeteringController";

    private MeteringCallback mMeteringCallback;
    private Metering mMetering;

    public MeteringController(ManualType manualType) {
        mMetering = new CenterMetering(this, manualType);
    }

    public void setMeteringCallback(MeteringCallback callback) {
        mMeteringCallback = callback;
    }

    @Override
    public Metering onFaceEvent(boolean hasFace, Rect rect) {
        return mMetering.onFaceEvent(hasFace, rect);
    }

    @Override
    public Metering onManualEvent(ManualType meterType, Rect meterRect, Rect focusRect, Point manualCenter) {
        return mMetering.onManualEvent(meterType, meterRect, focusRect, manualCenter);
    }

    @Override
    public void onFrameAvailable(byte[] yuvData, int width, int height) {
        mMetering.onFrameAvailable(yuvData, width, height);
    }

    @Override
    public void reset() {
        mMetering.reset();
    }

    void switchState(Metering metering) {
        if (mMeteringCallback != null) {
            mMeteringCallback.onMeteringChanged(mMetering, metering);
        }
        mMetering = metering;
    }

    void showMessage(String msg) {
        if (mMeteringCallback != null) {
            mMeteringCallback.onMessage(msg);
        }

    }
}
