package sg.bigo.libvideo.cam.metering;

import android.graphics.Point;
import android.graphics.Rect;

import sg.bigo.libvideo.cam.abs.Log;

/**
 * @author wilbert
 * @Date 2020/12/22 18:33
 * @email jiangwang.wilbert@bigo.sg
 **/
public abstract class Metering implements IMetering {
    private final String TAG = "Metering";

    public enum ExposureStatus {
        FACE_EXIST, CENTER_METERING, MANUAL, DEFAULT;
    }

    protected final MeteringController mController;
    protected final ExposureStatus mState;
    protected boolean mHasFace = false;
    protected boolean faceMeteringState = false;
    protected boolean mHasManual = false;
    protected Point mManualCenter;
    protected Rect mMeterRect = new Rect(0, 0, 0, 0);
    protected Rect mFocusRect = new Rect(0, 0, 0, 0);
    protected ManualType mMeterType;

    protected Metering(MeteringController controller, ExposureStatus state, ManualType manualType) {
        mController = controller;
        mState = state;
        mMeterType = manualType;
    }

    @Override
    public Metering onFaceEvent(boolean hasFace, Rect rect) {
        if (mHasManual) {
            //当前正处于手动模式
            return this;
        }
        if (hasFace != mHasFace) {
            //只走人脸切换时候的逻辑
            mHasFace = hasFace;
            mMeterRect = rect;
        }
        return this;
    }

    @Override
    public Metering onManualEvent(ManualType meterType, Rect meterRect, Rect focusRect, Point centerPoint) {
        if (MeteringDelegate.sDebug) {
            Log.e(TAG, "onManualEvent:" + meterType.name() + ";meterRect:" + meterRect + ";focusRect:" + focusRect + ";centerPoint:" + centerPoint);
        }
        mManualCenter = centerPoint;
        mMeterType = meterType;
        mHasManual = true;
        mMeterRect = meterRect;
        mFocusRect = focusRect;
        return this;
    }

    @Override
    public void reset() {
        resetFlag();
        mHasFace = false;
        mMeterRect.set(0, 0, 0, 0);
        mFocusRect.set(0, 0, 0, 0);
    }

    public Metering resetFlag() {
        mHasFace = false;
        mHasManual = false;
        return this;
    }

    public ExposureStatus getState() {
        return mState;
    }

    public Rect getMeterRect() {
        return mMeterRect;
    }

    public Rect getFocusRect() {
        return mFocusRect;
    }

    public ManualType getManualType() {
        return mMeterType;
    }

}