package sg.bigo.libvideo.cam.metering;

/**
 * @author wilbert
 * @Date 2020/12/22 18:33
 * @email jiangwang.wilbert@bigo.sg
 **/
public class FaceMetering extends Metering {

    private static final String TAG = "FaceMetering";
    private ManualType mManualType;
    private long mLastFaceMeteringTime = 0L;

    protected FaceMetering(MeteringController controller, ManualType manualType) {
        super(controller, ExposureStatus.FACE_EXIST, manualType);
        mManualType = manualType;
    }

    @Override
    public void onFrameAvailable(byte[] yuvData, int width, int height) {
        if (mHasManual) {
            //有手动对焦优先手动对焦
            //resetFlag避免在切换时调用两遍回调
            mController.switchState(new ManualMetering(mController, mManualType).onManualEvent(mMeterType, mMeterRect, mFocusRect, mManualCenter).resetFlag());
            return;
        }

        // 如果是对人脸测光模式，则需要不断更新对人脸 Rect 的测光（针对系统未实验自动人脸测光的机型）
        if (mHasFace && mMeterType.equals(ManualType.TYPE_MANUAL_FACE)) {
            mController.switchState(new FaceMetering(mController, mManualType).onFaceEvent(mHasFace, mMeterRect).resetFlag());
            return;
        }

        // 从系统默认测光到人脸测光状态需要进行一次主动测光
        if (mHasFace && mMeterType.equals(ManualType.TYPE_MANUAL_SMART) && !faceMeteringState) {
            mController.switchState(this);
            faceMeteringState = true;
            return;
        }

        mController.switchState(new DefaultMetering(mController, mManualType).onFaceEvent(mHasFace, mMeterRect).resetFlag());
        // 人脸测光一次后，重置状态
        faceMeteringState = false;
    }
}
