package sg.bigo.libvideo.cam.metering;

/**
 * @author wilbert
 * @Date 2021/1/14 22:00
 * @email jiangwang.wilbert@bigo.sg
 **/
public class DefaultMetering extends Metering {
    private ManualType mManualType;

    protected DefaultMetering(MeteringController controller, ManualType manualType) {
        super(controller, ExposureStatus.DEFAULT, manualType);
        mManualType = manualType;
    }

    @Override
    public void onFrameAvailable(byte[] yuvData, int width, int height) {
        if (mHasManual) {
            //resetFlag避免在切换时调用两遍回调
            mController.switchState(new ManualMetering(mController, mManualType).onManualEvent(mMeterType, mMeterRect, mFocusRect, mManualCenter).resetFlag());
            mHasManual = false;
            return;
        }

        if (mHasFace && mMeterType.equals(ManualType.TYPE_MANUAL_FACE)) {
            mController.switchState(new FaceMetering(mController, mManualType).onFaceEvent(mHasFace, mMeterRect).resetFlag());
        }
    }
}
