package sg.bigo.libvideo.cam.metering;

/**
 * @author wilbert
 * @Date 2020/12/22 18:33
 * @email jiangwang.wilbert@bigo.sg
 **/
public class CenterMetering extends Metering {
    private ManualType mManualType;
    private static final String TAG = "CenterMetering";

    protected CenterMetering(MeteringController controller, ManualType manualType) {
        super(controller, ExposureStatus.CENTER_METERING, manualType);
        mManualType = manualType;
    }

    @Override
    public void onFrameAvailable(byte[] yuvData, int width, int height) {
        if (mHasManual) {
            //resetFlag避免在切换时调用两遍回调
            mController.switchState(new ManualMetering(mController, mManualType).onManualEvent(mMeterType, mMeterRect, mFocusRect, mManualCenter).resetFlag());
            mHasManual = false;
            return;
        }
        if (mHasFace) {
            // 如果是默认没有开启人脸测光的机型，则使用本地的人脸测光策略
            mController.switchState(new FaceMetering(mController, mManualType).onFaceEvent(mHasFace, mMeterRect).resetFlag());
        } else {
            // 如果是默认开启人脸测光的机型，人脸测光交于系统托管
            mController.switchState(new DefaultMetering(mController, mManualType).onFaceEvent(mHasFace, mMeterRect).resetFlag());
        }
    }
}
