package sg.bigo.libvideo.cam.camera2;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;

import androidx.annotation.RequiresApi;

import java.util.ArrayList;
import java.util.List;

import sg.bigo.libvideo.cam.runtime.VcContext;
import sg.bigo.libvideo.cam.abs.VcCharacteristics;
import sg.bigo.libvideo.cam.abs.VcProperties;
import sg.bigo.libvideo.cam.abs.VcRectAngle;
import sg.bigo.libvideo.cam.abs.VcSize;

@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
public class VcCamera2Characteristics implements VcCharacteristics {

    private String mCameraIndex;
    private CameraCharacteristics mDevCharacteristics;

    public VcCamera2Characteristics(String cameraIndex) {
        mCameraIndex = cameraIndex;
        try {
            CameraManager manager = (CameraManager) VcContext.appContext().getSystemService(Context.CAMERA_SERVICE);
            mDevCharacteristics = manager.getCameraCharacteristics(mCameraIndex);
        } catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public void init(CameraCharacteristics cameraCharacteristics) {
        mDevCharacteristics = cameraCharacteristics;
    }

    @Override
    public String getCameraIndex() {
        return mCameraIndex;
    }

    @Override
    public int getAPILevel() {
        return 0;
    }

    @Override
    public void setCameraStatus(int status) {

    }

    @Override
    public int getCameraStatus() {
        return 0;
    }

    @Override
    public int isFacingFront(List<Integer> outData) {
        if (mDevCharacteristics == null) {
            return VcProperties.Constant.UNAVAILABLE;
        }
        Integer facing = mDevCharacteristics.get(CameraCharacteristics.LENS_FACING);
        if (facing != null && facing == CameraCharacteristics.LENS_FACING_FRONT) {
            outData.add(VcProperties.Constant.TRUE);
            return VcProperties.Constant.TRUE;
        }
        return VcProperties.Constant.FALSE;
    }

    @Override
    public int getOrientation(List<Integer> outData) {
        if (mDevCharacteristics == null) {
            return VcProperties.Constant.UNAVAILABLE;
        }
        Integer orientation = mDevCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (orientation != null) {
            outData.add(orientation);
            return VcProperties.Constant.TRUE;
        }
        return VcProperties.Constant.FALSE;
    }

    @Override
    public void prepare(int preferWidth, int preferHeight, int bufferType) {

    }

    @Override
    public int isZoomSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int isSmoothZoomSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int isVideoStabilizationSupported(List<Integer> outData) {
        return 0;
    }


    @Override
    public int setFocusMode(int focusMode) {
        return 0;
    }

    @Override
    public int getFocusMode(List<Integer> outData) {
        return 0;
    }

    @Override
    public int getMaxZoom(List<Integer> outData) {
        if (mDevCharacteristics == null) {
            return VcProperties.Constant.UNAVAILABLE;
        }
        Float maxZoom = mDevCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (maxZoom != null) {
            outData.add((int) (maxZoom * 10 - 9));
            return VcProperties.Constant.TRUE;
        }
        return VcProperties.Constant.FALSE;
    }

    @Override
    public int getDefaultZoom(List<Integer> outData) {
        return 0;
    }

    @Override
    public int isFocusSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int isAutoFocusSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int setAutoFocus() {
        return 0;
    }

    @Override
    public int isVideoContinuousFocusSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int getSupportedPreviewSizes(List<Integer> size) {
        return 0;
    }

    @Override
    public int getSupportedFlashModes(List<Integer> modes) {
        return 0;
    }

    @Override
    public int isMeteringSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int setMeteringArea(Rect rect, int weight) {
        return 0;
    }

    @Override
    public int resetMeteringState() {
        return 0;
    }

    @Override
    public int getFocusAreas(ArrayList<VcRectAngle> areas) {
        return 0;
    }

    @Override
    public int setFocusAreas(Rect rect, int weight) {
        return 0;
    }

    @Override
    public int resetFocusState() {
        return 0;
    }

    @Override
    public int getMeteringAreas(ArrayList<VcRectAngle> areas) {
        return 0;
    }

    @Override
    public int requestExposureFocus(int touch_x, int touch_y, int viewWidth, int viewHeight) {
        return 0;
    }

    @Override
    public int setZoom(int zoom) {
        return 0;
    }

    @Override
    public int getZoom(List<Integer> outData) {
        return 0;
    }

    @Override
    public int getPreferSize(List<Integer> size) {
        return 0;
    }

    @Override
    public int setPreviewSize(int[] size) {
        return 0;
    }

    @Override
    public int getPreviewSize(List<Integer> size) {
        return 0;
    }

    @Override
    public int setBufferType(int bufferType) {
        return 0;
    }

    @Override
    public int getBufferType(List<Integer> outData) {
        return 0;
    }

    @Override
    public int setFlashMode(int mode) {
        return 0;
    }

    @Override
    public int isFlashSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int isFlashModeTorchSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int getFlashMode(List<Integer> outData) {
        return 0;
    }

    @Override
    public int setStabilization(int mode) {
        return 0;
    }

    @Override
    public int getStabilization(List<Integer> outData) {
        return 0;
    }

    @Override
    public int getSupportedPreviewFpsRange(List<Integer> rangeList) {
        return 0;
    }

    @Override
    public int getPreviewFpsRange(List<Integer> fpsRange) {
        return 0;
    }

    @Override
    public int setPreviewFpsRange(int[] range) {
        return 0;
    }

    @Override
    public int isAntibandingsSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int isAntibandingAutoSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int setAntibandingMode(int mode) {
        return 0;
    }

    @Override
    public int getAntiBandingMode(List<Integer> outData) {
        return 0;
    }

    @Override
    public int isFaceDetectionSupported(List<Integer> outData) {
        return 0;
    }

    @Override
    public int getMaxNumDetectedFaces(List<Integer> outData) {
        return 0;
    }

}
