package sg.bigo.libvideo.cam.camera2;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraManager;
import android.os.Build;

import androidx.annotation.RequiresApi;

import sg.bigo.libvideo.cam.runtime.VcContext;
import sg.bigo.libvideo.cam.abs.VcApi;
import sg.bigo.libvideo.cam.abs.VcCamera;
import sg.bigo.libvideo.cam.abs.VcCharacteristics;
import sg.bigo.libvideo.cam.abs.VcProperties;

@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)

public class VcCamera2Api implements VcApi {
    @Override
    public VcCamera createCamera() {
        return new VcCamera2Impl();
    }

    @Override
    public VcCharacteristics createCharacteristics(String cameraIndex) {
        return new VcCamera2Characteristics(cameraIndex);
    }

    @Override
    public String[] getDeviceIdList(int cameraApi) {
        try {
            CameraManager manager = (CameraManager) VcContext.appContext().getSystemService(Context.CAMERA_SERVICE);
            return manager.getCameraIdList();
        } catch (CameraAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int getCameraApi() {
        return VcProperties.API.CAMERA2;
    }
}
