package sg.bigo.libvideo.cam.camera1;

import android.hardware.Camera;

import sg.bigo.libvideo.cam.abs.Log;
import sg.bigo.libvideo.cam.abs.VcApi;
import sg.bigo.libvideo.cam.abs.VcCamera;
import sg.bigo.libvideo.cam.abs.VcCharacteristics;
import sg.bigo.libvideo.cam.abs.VcProperties;

public class VcCameraApi implements VcApi {
    private final String TAG = "VcCameraApi";

    @Override
    public VcCamera createCamera() {
        Log.e(TAG, "createCamera");
        return new VcCameraImpl();
    }

    @Override
    public VcCharacteristics createCharacteristics(String cameraIndex) {
        Log.e(TAG, "createCharacteristics:" + cameraIndex);
        return new VcCameraCharacteristics(cameraIndex);
    }

    @Override
    public String[] getDeviceIdList(int cameraApi) {
        int nums = Camera.getNumberOfCameras();
        String[] result = new String[nums];
        for (int i = 0; i < nums; i++) {
            result[i] = i + "";
        }
        Log.e(TAG, "getDeviceIdList:" + cameraApi + ";deviceSize:" + result.length);
        return result;
    }

    @Override
    public int getCameraApi() {
        return VcProperties.API.CAMERA1;
    }
}
