package sg.bigo.libvideo.cam.abs;

import android.hardware.Camera;
import android.os.Build;

import java.util.Objects;

public class VcSize {

    private final String TAG = "Size";
    int mWidth;
    int mHeight;

    public VcSize() {
    }

    public VcSize(int w, int h) {
        mWidth = w;
        mHeight = h;
    }

    public VcSize(Camera.Size size) {
        if (size != null) {
            mWidth = size.width;
            mHeight = size.height;
        }
    }

    public int getWidth() {
        return mWidth;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public int getHeight() {
        return mHeight;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof VcSize)) return false;
        VcSize vcSize = (VcSize) o;
        return mWidth == vcSize.mWidth && mHeight == vcSize.mHeight;
    }

    @Override
    public int hashCode() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            return Objects.hash(mWidth, mHeight);
        } else {
            return super.hashCode();
        }
    }
}