package sg.bigo.libvideo.cam.abs;

import android.os.Build;

import java.util.List;
import java.util.Objects;

public class VcRectAngle {
    private int left, top, right, bottom, weight;

    public VcRectAngle(int l, int t, int r, int b, int w) {
        this.left = l;
        this.top = t;
        this.right = r;
        this.bottom = b;
        this.weight = w;
    }

    public int getLeft() {
        return left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getTop() {
        return top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getRight() {
        return right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getBottom() {
        return bottom;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void packData(List<Integer> outData) {
        if (outData == null) {
            return;
        }
        outData.add(left);
        outData.add(top);
        outData.add(right);
        outData.add(bottom);
        outData.add(weight);
    }

    public void packData(int[] outData, int offset) {
        if (offset + 5 >= outData.length || offset < 0) {
            return;
        }
        outData[offset] = left;
        outData[offset + 1] = top;
        outData[offset + 2] = right;
        outData[offset + 3] = bottom;
        outData[offset + 4] = weight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof VcRectAngle)) return false;
        VcRectAngle that = (VcRectAngle) o;
        return getLeft() == that.getLeft() && getTop() == that.getTop() && getRight() == that.getRight() && getBottom() == that.getBottom() && getWeight() == that.getWeight();
    }

    @Override
    public int hashCode() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            return Objects.hash(getLeft(), getTop(), getRight(), getBottom(), getWeight());
        } else {
            return super.hashCode();
        }
    }
}
