package sg.bigo.libvideo.cam.abs;

import android.text.TextUtils;

public class VcProperties {


    public interface API {
        int UNKNOWN = 0;
        int CAMERA1 = 1;
        int CAMERA2 = 2;
        int HUAWEI = 3;
        int OPPO = 4;
    }

    public interface OutputType {
        int UNKNOWN = 0;
        int NV21 = 1;
        int YUV420P = 2;
        int SURFACE_TEXTURE = 4;
    }

    public interface DataDriveMode {
        int kDataDrive_Get = 0;         //!< 外部线程每帧获取frame流程, 通过调用getCameraSource方法获取数据源对象
        int kDataDrive_Push = 1;            //!< 内部数据驱动， 通过外部注册回调函数，进行调用
    }

//    ///< 相机参数Key枚举
//    public interface CameraParamKey {
//        int kParam_Unknow = 0;
//        /**delete*/int kParam_Preset = 1;                          //!< 分辨率  kParamType_Int
//        int kParam_FrameRate = 2;                       //!< 帧率   kParamType_IntVec
//        int kParam_Stabilization = 3;                   //!< 防抖   kParamType_Int
//        int kParam_Zoom = 4;                            //!< zoom   kParamType_Int
//        int kParam_Flash = 5;                           //!< 闪光灯  kParamType_Int
//        int kParam_Focus_Mode = 6;                      //!< 对焦模式 kParamType_Int
//        int kParam_Focus_Touch = 7;                     //!< 点击对焦 kParamType_IntVec2
//        int kParam_Exposure_Mode = 8;                   //!< 曝光模式 kParamType_Int
//        int kParam_Exposure_Touch = 9;                  //!< 点击曝光 kParamType_IntVec
//        /**delete*/int kParam_ColorRange = 10;                     //!< 色域(主要为YUV videoRange， FullRange的查询与设置) 见:  enum BufferColorRange (kParamType_Int)
//        /**delete*/int kParam_Whitebalance = 11;
//        /**delete*/int kParam_HDR = 12;
//        /**delete*/ int kParam_ColorSpace = 13;
//        /**delete*/int kParam_Global_ToneMapping = 14;
//        int kParam_AnitBanding = 15;                     //!< 抗频闪模式
//        int kParam_Device = 16;                          //!< 设备固定参数  kParamType_Device 16
//        /**delete*/int kParam_MaxZoom = 17;                         //!< maxZoom   kParamType_Int 17
//        int kParam_PreviewSizesSupported = 18;           //!< maxZoom   kParamType_IntVec   18
//        int kParam_Exposure_Focus_Touch = 19;            //!< 测光对焦   kParamType_Int4Vec 19
//        /**delete*/int kParam_Status = 20;                          //!< 查询当前状态参数
//        /**delete*/int kParam_BufferType = 21;
//        /**delete*/int kParam_PreviewFpsRangeSupported = 22;        //!< 查询支持的预览帧率范围
//        /**delete*/int kParam_FlashSupported = 23;                  //!< 查询是否支持闪光灯
//        /**delete*/int kParam_FlashModeTorchSupported = 24;         //!< 查询是否支持闪光手电筒模式
//        /**delete*/int kParam_ZoomSupported = 25;                   //!< 查询是否支持 zoom
//        /**delete*/int kParam_ExposureSupported = 26;               //!< 查询是否支持区域测光
//        /**delete*/int kParam_FocusSupported = 27;                  //!< 查询是否支持区域对焦
//        /**delete*/int kParam_AutoFocusSupported = 28;              //!< 查询是否支持自动对焦
//        /**delete*/int kParam_VideoContinuousFocusSupported = 29;   //!< 查询是否支持连续对焦
//        /**delete*/int kParam_FaceDetectionSupported = 30;          //!< 查询是否支持人脸检测
//        /**delete*/int kParam_MaxNumDetectedFaces = 31;             //!< 查询最大人间检测数量
//        /**delete*/int kParam_AntiBandingSupported = 32;            //!< 查询是否支持抗条纹
//        /**delete*/int kParam_AntiBandingAutoSupported = 33;        //!< 查询是否支持自动抗条纹模式
//        /**delete*/int kParam_StabilizationSupported = 34;          //!< 查询是否支持防抖
//    }

    public interface CameraStatus {
        int kStatus_Prepared = -1;
        int kStatus_UnKnown = 0;
        int kStatus_Opened = 1;
        int kStatus_Closed = 2;
        //!
        //!
        //!ios相机系统回调状态上报
        int kStatus_WasInterrupted = 3;                            //!<  相机被打断
        int kStatus_InterruptionEnd = 4;                           //!<  打断结束
        int kStatus_RuntimeError = 5;                              //!<  异常错误 Posted when an unexpected error occurs while an AVCaptureSession instance is running
        int kStatus_DidStart = 6;                                  //!<  相机打开成功 Posted when an instance of AVCaptureSession successfully starts running
        int kStatus_DidEnd = 7;                                    //!< 相机停止成功 Posted when an instance of AVCaptureSession stops running
    }

    public static String getCameraStateName(Integer mode) {
        if (mode == null) {
            return "";
        }
        switch (mode) {
            case CameraStatus.kStatus_Opened:
                return "Opened";
            case CameraStatus.kStatus_Closed:
                return "Closed";
            default:
            case CameraStatus.kStatus_UnKnown:
                return "UnKnown";
        }
    }

    public static Integer getCameraState(String name) {
        if (TextUtils.isEmpty(name)) {
            return null;
        } else if (TextUtils.equals(name, "Opened")) {
            return CameraStatus.kStatus_Opened;
        } else if (TextUtils.equals(name, "Closed")) {
            return CameraStatus.kStatus_Closed;
        } else {
            return CameraStatus.kStatus_UnKnown;
        }
    }

    public interface FocusMode {
        int FOCUS_MODE_AUTO = 0;
        int FOCUS_MODE_INFINITY = 1;
        int FOCUS_MODE_MACRO = 2;
        int FOCUS_MODE_FIXED = 3;
        int FOCUS_MODE_EDOF = 4;
        int FOCUS_MODE_CONTINUOUS_VIDEO = 5;
        int FOCUS_MODE_CONTINUOUS_PICTURE = 6;
    }

    public static String getFocusModeName(Integer mode) {
        if (mode == null) {
            return "";
        }
        switch (mode) {
            case FocusMode.FOCUS_MODE_AUTO:
                return "auto";
            case FocusMode.FOCUS_MODE_INFINITY:
                return "infinity";
            case FocusMode.FOCUS_MODE_MACRO:
                return "macro";
            case FocusMode.FOCUS_MODE_FIXED:
                return "fixed";
            case FocusMode.FOCUS_MODE_EDOF:
                return "edof";
            case FocusMode.FOCUS_MODE_CONTINUOUS_VIDEO:
                return "continuous-video";
            case FocusMode.FOCUS_MODE_CONTINUOUS_PICTURE:
                return "continuous-picture";
        }
        return "";
    }

    public static Integer getFocusMode(String name) {
        if (TextUtils.isEmpty(name)) {
            return null;
        }
        if (TextUtils.equals(name, "auto")) {
            return FocusMode.FOCUS_MODE_AUTO;
        }
        if (TextUtils.equals(name, "infinity")) {
            return FocusMode.FOCUS_MODE_INFINITY;
        }
        if (TextUtils.equals(name, "macro")) {
            return FocusMode.FOCUS_MODE_MACRO;
        }
        if (TextUtils.equals(name, "fixed")) {
            return FocusMode.FOCUS_MODE_FIXED;
        }
        if (TextUtils.equals(name, "edof")) {
            return FocusMode.FOCUS_MODE_EDOF;
        }
        if (TextUtils.equals(name, "continuous-video")) {
            return FocusMode.FOCUS_MODE_CONTINUOUS_VIDEO;
        }
        if (TextUtils.equals(name, "continuous-picture")) {
            return FocusMode.FOCUS_MODE_CONTINUOUS_PICTURE;
        }

        return VcProperties.Constant.UNAVAILABLE;
    }

    public interface FlashMode {
        int FLASH_MODE_OFF = 0;
        int FLASH_MODE_AUTO = 1;
        int FLASH_MODE_ON = 2;
        int FLASH_MODE_RED_EYE = 3;
        int FLASH_MODE_TORCH = 4;
    }

    public static String getFlashModeName(Integer mode) {
        if (mode == null) {
            return "";
        }
        switch (mode) {
            case FlashMode.FLASH_MODE_OFF:
                return "off";
            case FlashMode.FLASH_MODE_AUTO:
                return "auto";
            case FlashMode.FLASH_MODE_ON:
                return "on";
            case FlashMode.FLASH_MODE_RED_EYE:
                return "red-eye";
            case FlashMode.FLASH_MODE_TORCH:
                return "torch";
        }
        return "";
    }

    public static Integer getFlashMode(String name) {
        if (TextUtils.isEmpty(name)) {
            return null;
        }
        if (TextUtils.equals(name, "off")) {
            return FlashMode.FLASH_MODE_OFF;
        }
        if (TextUtils.equals(name, "auto")) {
            return FlashMode.FLASH_MODE_AUTO;
        }
        if (TextUtils.equals(name, "on")) {
            return FlashMode.FLASH_MODE_ON;
        }
        if (TextUtils.equals(name, "red-eye")) {
            return FlashMode.FLASH_MODE_RED_EYE;
        }
        if (TextUtils.equals(name, "torch")) {
            return FlashMode.FLASH_MODE_TORCH;
        }
        return VcProperties.Constant.UNAVAILABLE;
    }

    public interface AntibandingMode {
        int ANTIBANDING_AUTO = 0;
        int ANTIBANDING_50HZ = 1;
        int ANTIBANDING_60HZ = 2;
        int ANTIBANDING_OFF = 3;
    }

    public static String getAntibandingModeName(Integer mode) {
        if (mode == null) {
            return "";
        }
        switch (mode) {
            case AntibandingMode.ANTIBANDING_AUTO:
                return "auto";
            case AntibandingMode.ANTIBANDING_50HZ:
                return "50hz";
            case AntibandingMode.ANTIBANDING_60HZ:
                return "60hz";
            case AntibandingMode.ANTIBANDING_OFF:
                return "off";
        }
        return "";
    }

    public static Integer getAntibandingMode(String name) {
        if (TextUtils.isEmpty(name)) {
            return null;
        }
        if (TextUtils.equals(name, "auto")) {
            return AntibandingMode.ANTIBANDING_AUTO;
        }
        if (TextUtils.equals(name, "50hz")) {
            return AntibandingMode.ANTIBANDING_50HZ;
        }
        if (TextUtils.equals(name, "60hz")) {
            return AntibandingMode.ANTIBANDING_60HZ;
        }
        if (TextUtils.equals(name, "off")) {
            return AntibandingMode.ANTIBANDING_OFF;
        }
        return VcProperties.Constant.UNAVAILABLE;
    }

    public interface Constant {
        int TRUE = 1;
        int FALSE = 0;
        int UNAVAILABLE = -1;
    }

    ///< 错误码集合
    public interface ErrCode {
        int kErr_None = 0;                          //!< ok
        int kErr_DoneTwice = 1;                         //!< 打开相机错误
        int kErr_NotSupported = 2;                      //!< 类型不支持
        int kErr_OSNotSupported = 3;                    //!< 系统版本不支持
        int kErr_NotInitialized = 4;                    //!< 未初始化
        int kErr_OpenCamera = 5;                        //!< 打开相机错误
        int kErr_SetCameraParameter = 6;                //!< 设置相机参数错误

        ///!!新定义错误码
        int kErr_SceneTypeNotSupported = 7;
        int kErr_NotFindCaptureDevice = 8;              //!< 没找到设备
        int kErr_Unknown = 9;                          //!< unkown error
        int kErr_SystemErr = 10;                       //!< 系统错误（来自于系统api回调）
        int kErr_CloseCamera = 11;                      //!< 关闭相机错误
    }

    public interface LogLevel {
        int kLogLevel_Info = 0;
        int kLogLevel_Debug = 1;
        int kLogLevel_Warning = 2;
        int kLogLevel_Error = 3;
    };

    public enum OperateStatus {
        cameraId,
        isFront,
        api,
        capSize,
        status,
        errMsg,
        exception,
        stackTrace
    }
}
