package sg.bigo.libvideo.cam.abs;

import android.graphics.Rect;

import java.util.ArrayList;
import java.util.List;

public interface VcCharacteristics {

    String getCameraIndex();

    int getAPILevel();

    /********************** 静态参数**********************/
    void setCameraStatus(int status);

    int getCameraStatus();

    int isFacingFront(List<Integer> outData);

    int getOrientation(List<Integer> outData);

    void prepare(int preferWidth, int preferHeight, int bufferType);

    /********************** 静态参数**********************/
    int isZoomSupported(List<Integer> outData);

    int isSmoothZoomSupported(List<Integer> outData);

    int isVideoStabilizationSupported(List<Integer> outData);

    int getMaxZoom(List<Integer> outData);

    int getDefaultZoom(List<Integer> outData);

    int isFocusSupported(List<Integer> outData);

    int isAutoFocusSupported(List<Integer> outData);

    int setAutoFocus();

    int isVideoContinuousFocusSupported(List<Integer> outData);

    int setFocusMode(int focusMode);

    int getFocusMode(List<Integer> outData);

    int getFocusAreas(ArrayList<VcRectAngle> areas);

    int setFocusAreas(Rect rect, int weight);

    int resetFocusState();

    int getSupportedPreviewSizes(List<Integer> size);

    int getSupportedFlashModes(List<Integer> modes);

    int isMeteringSupported(List<Integer> outData);

    int setMeteringArea(Rect rect, int weight);

    int resetMeteringState();

    int getMeteringAreas(ArrayList<VcRectAngle> areas);

    int requestExposureFocus(int touch_x, int touch_y, int viewWidth, int viewHeight);

    int setZoom(int zoom);

    int getZoom(List<Integer> outData);

    int getPreferSize(List<Integer> size);

    int setPreviewSize(int[] size);

    int getPreviewSize(List<Integer> size);

    int setBufferType(int bufferType);

    int getBufferType(List<Integer> outData);

    int setFlashMode(int flashMode);

    int isFlashSupported(List<Integer> outData);

    int isFlashModeTorchSupported(List<Integer> outData);

    int getFlashMode(List<Integer> outData);

    int setStabilization(int stabilizationMode);

    int getStabilization(List<Integer> outData);

    int getSupportedPreviewFpsRange(List<Integer> rangeList);

    int getPreviewFpsRange(List<Integer> fpsRange);

    int setPreviewFpsRange(int[] fpsRange);

    int isAntibandingsSupported(List<Integer> outData);

    int isAntibandingAutoSupported(List<Integer> outData);

    int setAntibandingMode(int antibandingMode);

    int getAntiBandingMode(List<Integer> outData);

    int isFaceDetectionSupported(List<Integer> outData);

    int getMaxNumDetectedFaces(List<Integer> outData);
}
