package sg.bigo.libvideo.cam.abs;

public enum VcCameraScene {

    kScene_Unkown(0),                                                //!< unknown
    kSceneVideo(1 << 3),                                           //!< 视频, 默认前置
    kSceneVideo_Front(SCENE_SUBTYPE(kSceneVideo, 1)),                    //!< 视频, 前置
    kSceneVideo_Rear(SCENE_SUBTYPE(kSceneVideo, 2)),                    //!< 视频, 后置
    kScenePhoto(1 << 6),                                           //!< 拍照, 默认前置
    kScenePhoto_Front(SCENE_SUBTYPE(kScenePhoto, 1)),                    //!< 拍照, 前置
    kScenePhoto_Rear(SCENE_SUBTYPE(kScenePhoto, 2)),                    //!< 拍照, 后置
    kSceneAR(1 << 9),                                           //!< AR, 默认后置
    kSceneAR_Front(SCENE_SUBTYPE(kSceneAR, 1)),                       //!< AR, 前置
    kSceneAR_Rear(SCENE_SUBTYPE(kSceneAR, 2)),                       //!< AR, 后置
    kSceneVideo_Dual(1 << 12);                                          //!< 视频双摄像机(支持前置后置同时打开)

    VcCameraScene(int id) {
        sceneId = id;
    }

    public int sceneId;

    public static int SCENE_SUBTYPE(VcCameraScene type, int value) {
        return type.sceneId | value;
    }
}
