package sg.bigo.libvideo.cam.abs;

import static sg.bigo.libvideo.VcABConfig.VcABConfigKey.*;

import android.text.TextUtils;
import android.util.Pair;

import androidx.annotation.Keep;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import sg.bigo.libvideo.VcABConfig;
import sg.bigo.libvideo.VcABConfig.VcABConfigKey;
import sg.bigo.libvideo.cam.runtime.VcContext;
import sg.bigo.libvideo.cam.strategy.indexchoose.CameraIndexChooseFactory;

/**
 * 向c++中的DeviceManager提供调用
 */
@Keep
public class VcCameraDeviceManager {
    private static final String TAG = "VcCameraDeviceManager";
    private static HashMap<String, VcDevice> sDevices = new HashMap<>();

    /**
     * 获得支持的所有api类型
     *
     * @return
     */
    @Keep
    public static int[] getApiList() {
        Log.e(TAG, "getApiList");
        return VcApiFactory.getApiList();
    }

    /**
     * 指定api，获得其camera设备列表
     *
     * @param cameraApi
     * @return
     */
    @Keep
    public static String[] getDeviceIdList(int cameraApi) {
        Log.e(TAG, "getDeviceIdList,cameraApi:" + cameraApi);
        return VcApiFactory.factoryApi(cameraApi).getDeviceIdList(cameraApi);
    }

    @Keep
    public static String getBestDeviceId(int cameraApi, boolean isFront) {
        String index = "0";
        try {
            index = CameraIndexChooseFactory.createCameraChooseStategy(VcContext.appContext(), isFront) + "";
        } catch (Exception e) {
            e.printStackTrace();
        }
        Log.e(TAG, "[getBestDeviceId]index:" + index);
        return index;
    }

    /**
     * 指定api以及deviceId，获得一个VcCameraDevice
     *
     * @param cameraApi
     * @param deviceId
     * @return
     */
    @Keep
    public static VcDevice getCameraDevice(int cameraApi, String deviceId) {
        Log.e(TAG, "getCameraDevice cameraApi:" + cameraApi + ";deviceId:" + deviceId);
        String key = getDeviceKey(cameraApi, deviceId);
        VcDevice device = null;
        if (!TextUtils.isEmpty(key)) {
            device = sDevices.get(key);
            if (device == null) {
                device = new VcDevice(cameraApi, deviceId);
                sDevices.put(key, device);
            }
        }
        return device;
    }

    @Keep
    private static String getDeviceKey(int api, String deviceId) {
        if (TextUtils.isEmpty(deviceId)) {
            return null;
        }
        return api + "_" + deviceId;
    }

    /**
     * 指定 ABConfig 的 Key 值，获得一个 对应的配置
     *
     * @param ABConfigKeyIndex ABConfig 的 key 值
     * @return ABConfig 云控、实验配置结果
     */
    @Keep
    public static float getFloatABConfig(int ABConfigKeyIndex) {
        Log.e(TAG, "getFloatABConfig :" + ABConfigKeyIndex);
        float ABConfigValue = 0.f;
        if (ABConfigKeyIndex > values().length) {
            Log.e(TAG, "getFloatABConfig failed, ABConfigKeyIndex:" + ABConfigKeyIndex
                    + " out of bound" + values().length);
            return ABConfigValue;
        }
        VcABConfigKey vcABConfigKey = values()[ABConfigKeyIndex];
        switch (vcABConfigKey) {
            case ASPECT_RATIO_DEVIATION_WEIGHT:
                ABConfigValue = VcABConfig.getCaptureResolutionOptimizeWidth();
                Log.e(TAG, "aspect_ratio_deviation_weight : " + ABConfigValue);
                break;
            default:
                ABConfigValue = 0.f;
        }
        return ABConfigValue;
    }

    @Keep
    public static void setLogger(Object obj) {
        if (obj instanceof Log.ILog) {
            Log.setLogger((Log.ILog) obj);
        }
    }

    public static final String REPORT_SEPARATOR = "#RP#";
    public static final String REPORT_PAIRS_SEPARATOR = ";RP;";

    public static String packReportPairs(List<Pair<String, String>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Pair<String, String> reportInfo : pairs) {
            stringBuffer.append(reportInfo.first).
                    append(REPORT_SEPARATOR).
                    append(reportInfo.second).
                    append(REPORT_PAIRS_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public static List<Pair<String, String>> unPackReportPairs(String packedPairs) {
        if (TextUtils.isEmpty(packedPairs) || (!packedPairs.contains(REPORT_SEPARATOR))) {
            return null;
        }
        String[] pairStrs = packedPairs.split(REPORT_PAIRS_SEPARATOR);
        if (pairStrs == null || pairStrs.length <= 0) {
            return null;
        }
        List<Pair<String, String>> pairs = new ArrayList<>();
        for (String pair : pairStrs) {
            String[] keyValue = pair.split(REPORT_SEPARATOR);
            if (keyValue.length == 2) {
                Pair<String, String> p = new Pair<>(keyValue[0], keyValue[1]);
                pairs.add(p);
            }
        }
        return pairs;
    }

    public static void report(List<Pair<String, String>> reportPairs) {
        String reportMessage = packReportPairs(reportPairs);
        report(reportMessage);
    }

    public static native void report(String message);
}
