package sg.bigo.libvideo.cam.abs;

import android.graphics.SurfaceTexture;
import android.os.Handler;

import java.util.List;

public interface VcCamera {

    void setListener(VcListener listener);

    /**
     * 打开相机
     *
     * @param characteristics 相机参数
     * @return
     */
    int prepare(VcCharacteristics characteristics, int preferWidth, int preferHeight, int bufferType);

    /**
     * 根据现有参数打开相机
     *
     * @return
     */
    int open();

    /**
     * 关闭相机
     *
     * @return
     */
    int close();

    /**
     * 设置相机参数（用于对外提供相机通用接口）
     *
     * @param key
     * @param paramsInt
     * @return 操作结果（成功与否）
     */
    int applyParam(final int key, final int[] paramsInt);

    /**
     * 查询相机参数（用于对外提供相机通用查询接口）
     *
     * @param key
     * @return 查询结果
     */
    int queryParam(final int key, List<Integer> result);

    /**
     * 获得相机参数值，相机未开启前camera1的某些值可能无法获得
     *
     * @return
     */
    VcCharacteristics getCharacteristics();

    SurfaceTexture getSurfaceTexture();

    String getCameraIndex();
}
