package sg.bigo.libvideo.cam.abs;

import android.os.Build;

import sg.bigo.libvideo.cam.camera1.VcCameraApi;
import sg.bigo.libvideo.cam.camera2.VcCamera2Api;

public class VcApiFactory {
    private static final String TAG = "VcApiFactory";

    public static VcApi factoryApi(int api) {
        switch (api) {
            case VcProperties.API.CAMERA2:
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    return new VcCamera2Api();
                }
            case VcProperties.API.HUAWEI:
            case VcProperties.API.OPPO:
            default:
                return new VcCameraApi();
        }
    }

    public static int[] getApiList() {
        return new int[]{VcProperties.API.CAMERA1, VcProperties.API.CAMERA2, VcProperties.API.HUAWEI, VcProperties.API.OPPO};
    }
}
