package sg.bigo.libvideo.cam.abs;

public class Log {
    private static ILog mLogger = null;

    public static void e(String tag, String message) {
        log(VcProperties.LogLevel.kLogLevel_Error, "" + tag + " " + message);
    }

    public static void e(String tag, String message, Throwable e) {
        String error = VcUtils.getStackTrace(e);
        log(VcProperties.LogLevel.kLogLevel_Error, "" + tag + " " + message + "\n\r" + error);
    }

    public static void w(String tag, String message) {
        log(VcProperties.LogLevel.kLogLevel_Warning, "" + tag + " " + message);
    }

    public static void w(String tag, String message, Throwable e) {
        String error = VcUtils.getStackTrace(e);
        log(VcProperties.LogLevel.kLogLevel_Warning, "" + tag + " " + message + "\n\r" + error);
    }

    public static void i(String tag, String message) {
        log(VcProperties.LogLevel.kLogLevel_Info, "" + tag + " " + message);
    }

    public interface ILog {
        void log(int level, String message);
    }

    public static void setLogger(ILog logger) {
        mLogger = logger;
    }

    private static void log(int level, String message) {
        if (mLogger != null) {
            mLogger.log(level, message);
        }
    }
}
