package sg.bigo.libvideo;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import sg.bigo.libvideo.cam.abs.Log;
import sg.bigo.libvideo.cam.metering.ManualType;
import sg.bigo.libvideo.cam.strategy.indexchoose.CameraChooseStrategy;

public class VcABConfig {
    private static final String TAG = "VcABConfig";
    private static Map<String, String> mJsonStringPairCollector = new HashMap<>();

    public static final String CAMERA_CHOOSE_STRATEGY = "camera_choose_strategy";
//    public static CameraChooseStrategy chooseStrategy = CameraChooseStrategy.DEFAUTL_CHOOSE_MAIN;
    public static CameraChooseStrategy chooseStrategy = CameraChooseStrategy.SAMSUNG_FRONT_OPTIMIZE;

    public static final String LIVE_ENABLE_CAMERA2 = "live_enable_camera2";
    public static String live_enable_camera2_value = "false";

    public static final String LIVE_FACE_METERING_STRATEGY_VS = "likee_live_face_metering_strategy_vs";
    public static ManualType live_face_metering_strategy = ManualType.TYPE_MANUAL_SMART;

    public static final String LIVE_FACE_METERING_STRATEGY_FORCE_LOCK = "likee_live_face_metering_strategy_force_lock";
    public static boolean live_face_metering_strategy_force_lock = false;

    public static final String LIVE_FACE_METERING_STRATEGY_FORCE_FACE = "likee_live_face_metering_strategy_force_face";
    public static boolean live_face_metering_strategy_force_face = false;

    private static final String LIVE_RESOLUTION_OPTIMIZE = "live_resolution_optimize";
    private static final String ASPECT_RATIO_DEVIATION_WEIGHT = "aspect_ratio_deviation_weight";
    private static float aspect_ratio_deviation_weight = 1.8f;


    public enum VcABConfigKey {
        ASPECT_RATIO_DEVIATION_WEIGHT,
    }

    public static CameraChooseStrategy getChooseStrategy() {
        return chooseStrategy;
    }

    public static ManualType getMeteringFocusConfig() {
        // 强制走自研人脸测光（系统未实现人脸测光）
        if (live_face_metering_strategy_force_face) {
            return ManualType.TYPE_MANUAL_FACE;
        }
        // 强制走测光之后锁定（系统自带场景检测测光）
        if (live_face_metering_strategy_force_lock) {
            return ManualType.TYPE_MANUAL_LOCK;
        }
        return live_face_metering_strategy;
    }

    public static float getCaptureResolutionOptimizeWidth() {
        synchronized (VcABConfig.class) {
            return aspect_ratio_deviation_weight;
        }
    }

    public synchronized static void setCommonConfigs(String[] keys, String[] values) {
        int index = 0;
        try {
            for (String key : keys) {
                if (key.equals(CAMERA_CHOOSE_STRATEGY)) {
                    chooseStrategy = CameraChooseStrategy.values()[Integer.parseInt(values[index])];
                } else if (key.equals(LIVE_ENABLE_CAMERA2)) {
                    live_enable_camera2_value = values[index];
                } else if (key.equals(LIVE_RESOLUTION_OPTIMIZE)) {
                    parseResolutionOptimizeParams(values[index]);
                } else if (key.equals(LIVE_FACE_METERING_STRATEGY_FORCE_LOCK)) {
                    live_face_metering_strategy_force_lock = Boolean.parseBoolean(values[index]);
                } else if (key.equals(LIVE_FACE_METERING_STRATEGY_FORCE_FACE)) {
                    live_face_metering_strategy_force_face = Boolean.parseBoolean(values[index]);
                } else if (key.equals(LIVE_FACE_METERING_STRATEGY_VS)) {
                    if (Integer.parseInt(values[index]) < ManualType.values().length) {
                        live_face_metering_strategy = ManualType.values()[Integer.parseInt(values[index])];
                        Log.e(TAG, "parase LIVE_FACE_METERING_STRATEGY_VS :" + live_face_metering_strategy.toString());
                    } else {
                        Log.e(TAG, "parase LIVE_FACE_METERING_STRATEGY_VS error:" + values[index]);
                    }

                }
                ++index;
            }
        } catch (Exception IllegalArgumentException) {
            Log.e("AbConfigManager", "IllegalArgumentException");
        }
    }

    private static void parseResolutionOptimizeParams(String abConfig) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(abConfig);
            synchronized (VcABConfig.class) {
                if (jsonObject == null) {
                    return;
                }
                aspect_ratio_deviation_weight = (float) jsonObject.optDouble(ASPECT_RATIO_DEVIATION_WEIGHT);
            }
        } catch (JSONException e) {
            e.printStackTrace();
            return;
        }
    }

    private static void getJsonAndPutToMap(JSONObject jsonObj, String name) {
        if (mJsonStringPairCollector != null) {
            mJsonStringPairCollector.put(name, jsonObj.optString(name));
        }
    }
}
