
local basetype = require "venuscore.rtti.types.basetype"
local AnyType = require "venuscore.rtti.types.any_type"

local AnyArrayType = basetype:extend("AnyArrayType");

AnyArrayType.elemType = AnyType

AnyArrayType.myExtend = AnyArrayType.extend

function AnyArrayType:extend(elemType)
  -- Blueprint-Generate Type(Class/Array) do NOT register to RttiManager
  local clazz = AnyArrayType.myExtend(self)
  clazz.elemType = elemType ;
  return clazz ;
end

function AnyArrayType:GetGivenElementTypeName(elemType)
  local BR = require "bluecore.core.blue_rtti"
  return BR.GetRealTypeName(elemType).."[]"
end

function AnyArrayType:new(get, set)
  AnyArrayType.super.new(self, get, set);
end

function AnyArrayType:isArray()
  return true ;
end

-- 编辑器上给用户看到的类名字
function AnyArrayType:GetDisplayName()
  local typeName = self.elemType.GetDisplayName and self.elemType:GetDisplayName() or self.elemType:GetTypeName()
  return  typeName.."[]"
end


function AnyArrayType:GetElementType()
  return self.elemType
end

-- 目前UE不支持数组输出到另外一个数组,即没有支持二维数组
-- 判断数组类型是否一致 只判断元素类型 而不判断数组元素数目
function AnyArrayType:isTypeOrDriverType(other)

  if other:isArray() then
    local b1 = other.elemType ;
    if b1 == nil then
      return false
    end
    local b2 = self.elemType ;
    if b2 == nil then
      return false
    end
    return b2:isTypeOrDriverType(b1)  --适用于数组中数组
  end
  return false

end


function AnyArrayType:isType(other)
  if other:isArray() then
    local b1 = other.elemType ;
    if b1 == nil then
      return false
    end
    local b2 = self.elemType ;
    if b2 == nil then
      return false
    end
    return b2:GetTypeID() == b1:GetTypeID()
  end
  return false
end

return AnyArrayType;