local libvenuscore = require "libvenuscore"
local object = require "venuscore.rtti.object"
local bit = require("bit")

local ActorNode = libvenuscore.Object:extend("ActorNode");

function ActorNode:new(name)
  self.node = libvenuscore.Actor();
  self.node._Script = self;
  self:SetName(name or "Actor");
  self.prefabPath = nil;
end

function ActorNode:GetNativeNode()
  return self.node;
end

function ActorNode:SetNativeNode(node)
  self.node = node;
end

function ActorNode:SetName(name)
  self.node:SetName(name);
end

function ActorNode:GetName()
  return self.node:GetName();
end

function ActorNode:AttachNode(node)
  if type(node) ~= "userdata" then
    self.node:AttachNode(node.node);
  end
  
end

function ActorNode:DetachNode(node)
  self.node:DetachNode(node.node);
end

function ActorNode:GetObjectID()
  return self.node:GetObjectID();
end

function ActorNode:GetComponentTypes()
  return self.node:GetComponentTypes();
end

function ActorNode:GetComponent(ct)
  local component = nil;
  if self.node then
    component = self.node:GetComponent(ct);
  end
  return component;
end

function ActorNode:GetStaticID()
  return self.node:GetStaticID();
end

function ActorNode:SetStaticID(staticID)
  self.node:SetStaticID(staticID);
end




return ActorNode;