local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local SetFadingTimeCommand = CommandBase:extend("SetFadingTimeCommand");

function SetFadingTimeCommand:new(uuid, transid, time)
  SetFadingTimeCommand.super.new(self);
    self._uuid = uuid;
    self._transid = transid;
    self._time =  time;
    self._prevtime = nil;
end

function SetFadingTimeCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani and self._transid ~= nil then
        local native_transition = ani:GetTransitionById(0, self._transid);
        self._prevtime = native_transition.Duration;
        native_transition.Duration = self._time;
      end
    end
    self:EndCmd();
end

function SetFadingTimeCommand:Undo()
    self:BeginCmd();
    if self._uuid then
        local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani and self._transid ~= nil then
        local native_transition = ani:GetTransitionById(0, self._transid);
        native_transition.Duration = self._prevtime;
      end
    end
    self:EndCmd();
end

return SetFadingTimeCommand;