local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local DeleteStateCommand = CommandBase:extend("DeleteStateCommand");

function DeleteStateCommand:new(uuid, delete_stateId)
    DeleteStateCommand.super.new(self);
    self._uuid = uuid;
    self._deleteId = delete_stateId;
end

function DeleteStateCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani and self._deleteId ~= nil then
        local state = ani:GetStateById(0, self._deleteId);
        ani:RemoveState(0, state);
      end
    end
    self:EndCmd();
end

function DeleteStateCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return DeleteStateCommand;