local AutoTensor = require "torchutility.autotensor"
local Operator = require "torchutility.operator"
local venusjson = require "venusjson"
local venuscore = require "venuscore"
local torch = require "torch"

local Length = Operator:extend();
local EPSILON = 1e-5;

function Length:new(autotensor, indexlist)
  Length.super.new(self, autotensor);
  self.vcount = autotensor:R():size()[1] * autotensor:R():size()[2];--位置变量的个数
  self.rcount = #indexlist;--关系的个数
  self.len = torch.Tensor(self.rcount):zero();
  self.indexlist = indexlist;
end

function Length:Caculate(pr)
  for i, bonepair in ipairs(self.indexlist) do
    local p1 = pr[bonepair[1]];
    local p2 = pr[bonepair[2]];
    local dif = p1 - p2;
    self.len[i] = dif:norm();
  end
  return self.len;
end

function Length:Derivative(pr)
  local J = torch.zeros(self.rcount, self.vcount);
  for i, bonepair in ipairs(self.indexlist) do
    local index1 = bonepair[1];
    local index2 = bonepair[2];
    local p1 = pr[index1];
    local p2 = pr[index2];
    local d = (p1 - p2)/self.len[i];
    local cbi1 = index1*3-2;
    local cbi2 = index2*3-2;
    J[{i, {cbi1, cbi1+2}}] = d
    J[{i, {cbi2, cbi2+2}}] = -d;
  end
  return J;
end

return Length;