local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local libvenuscore = require "libvenuscore"
local GetImage = BlueNode:extend();

local likeapp

if not _PLATFORM_WINDOWS then
  likeapp = require "likeapp"
end

---- 游戏运行模式
function GetImage:new(...)
  GetImage.super.new(self, ...)
end

function GetImage:_OnUpdate(args)
  if likeapp then
    local x,y,width,height,ts = likeapp.AI:GetImageCB();
    local te ;
    if ts ~= nil then
      te =  AE.TextureEntity();
      te:PushMetadata(
              AE.TextureBufferMetadata(
                      AE.TextureEntity.TU_STATIC, 1, false,
                      AE.TextureEntity.TW_CLAMP_TO_EDGE, -- 需要作为参数配置 ??
                      AE.TextureEntity.TW_CLAMP_TO_EDGE,
                      AE.TextureEntity.TF_NEAREST,
                      AE.TextureEntity.TF_NEAREST,
                      ts));
      te:SetJobType(libvenuscore.IJob.JT_SYNCHRONOUS);
      te:CreateResource();
    end
    WARNING(string.format("GetImage, (%d %d), (%d,%d))", x, y, width, height)..", te "..tostring(te));
    return x, y, width, height, te
  else
    -- Windows端 模拟交互获取图片
    WARNING("GetImage, blocked");

    local defaultSavePath = libvenuscore.IFileSystem:PathAssembly(SystemDirectories["scene_asset"]);
    libvenuscore.IApplication:GetMainWindow():OpenFileDialog("png,jpg", defaultSavePath);
    libvenuscore.IApplication:GetMainWindow():Update(); -- 挂起 等待
    local path = libvenuscore.IApplication:GetMainWindow():GetSelectedPath(); -- 忽略结果
    if #path ~= 0 then
      local filePath = path[1]
      WARNING("select file " ..tostring(filePath))
      local entity= AE.TextureEntity();
      entity:PushMetadata(AE.TextureFileMetadata(
              AE.TextureEntity.TU_STATIC,
              AE.TextureEntity.PF_AUTO,1, false,
              AE.TextureEntity.TW_CLAMP_TO_EDGE, -- 需要作为参数配置 ??
              AE.TextureEntity.TW_CLAMP_TO_EDGE,
              AE.TextureEntity.TF_NEAREST,
              AE.TextureEntity.TF_NEAREST,
              filePath)
      );
      entity:SetJobType(libvenuscore.IJob.JT_SYNCHRONOUS);
      entity:CreateResource();
      local size = entity:GetSize();
      return 0.5, 0.5, size.mx, size.my, entity ; -- 编辑器固定在屏幕的(0.5,0.5)  模拟调试
    else
      return 0, 0, 0, 0, nil ;
    end
  end
end

---- 编辑器模式

GetImage:RegisterOutput(1, Types.FloatType, "x", "x") -- 归一化
GetImage:RegisterOutput(2, Types.FloatType, "y", "y")
GetImage:RegisterOutput(3, Types.IntType, "width", "宽")
GetImage:RegisterOutput(4, Types.IntType, "height", "高")
GetImage:RegisterOutput(5, AE.TextureEntity:RTTI(), "Texture", "图片");

GetImage:RegisterExecInput(1, "exec", "执行");
GetImage:RegisterExecOutput(1, "exec", "执行");
GetImage:SetFunctionName("Get Image");
GetImage:SetFunctionType(BD.USER_INTERFACE_NODE);


--likeapp.AI:OnTriggerCB(2500);
--local x,y,width,height,ts = likeapp.AI:GetImageCB();
--ERROR("x = "..tostring(x))
--ERROR("y = "..tostring(y))
--ERROR("width = "..tostring(width))
--ERROR("height = "..tostring(height))
--ERROR("ts = "..tostring(ts))
--
--likeapp.AI:PublishImageCB(777,666, 14);

return GetImage;

