local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local GiftNotify = BlueNode:extend();

local likeapp

if not _PLATFORM_WINDOWS then
  likeapp = require "likeapp"
end

---- 游戏运行模式
function GiftNotify:new(...)
  GiftNotify.super.new(self, ...)
end

function GiftNotify:_OnUpdate(args)
  WARNING("GiftNotify:_OnUpdate!!");
  if likeapp then
	WARNING("Notyfy Client Gift shoule be released!!");
    likeapp.GiftInvokerProxy:CallGiftFinishFunction();
  else
    -- Windows端如何实现比较好?? 模拟通知客户端
    WARNING("TriggerNotify notify, blocked");
    local libvenuscore = require "libvenuscore"
    local defaultSavePath = libvenuscore.IFileSystem:PathAssembly("proj:");
	WARNING("*********************************************" .. defaultSavePath);
    libvenuscore.IApplication:GetMainWindow():OpenFileDialog("notify", defaultSavePath);
    libvenuscore.IApplication:GetMainWindow():Update(); -- 挂起 等待
    --libvenuscore.IApplication:GetMainWindow():GetSelectedPath(); -- 忽略结果
  end
  return true;
end

---- 编辑器模式
GiftNotify:RegisterInput(1, Types.IntType, "extra", "附加参数", 0);
GiftNotify:RegisterExecInput(1, "exec", "执行");
GiftNotify:RegisterExecOutput(1, "exec", "执行");
GiftNotify:SetFunctionName("GiftNotify");
GiftNotify:SetFunctionType(BD.USER_INTERFACE_NODE);

return GiftNotify ;

