local mf = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local ReverseVec2Y = BlueNode:extend();

function ReverseVec2Y:new(...)
  ReverseVec2Y.super.new(self, ...)
end

function ReverseVec2Y:_OnUpdate(args)
  return mf.vector2(args[1].mx, 1.0-args[1].my) ;
end

ReverseVec2Y:RegisterInput(1, mf.vector2:RTTI(), "1", "vec2(x,y)", mf.vector2(0.0,0.0));
ReverseVec2Y:RegisterOutput(1, mf.vector2:RTTI(), "vec2(x,1-y)", "vec2(x,1-y)");
ReverseVec2Y:SetFunctionName("vec2(x,1-y)");
ReverseVec2Y:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return ReverseVec2Y;
