local mf = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local MakeVector3f = BlueNode:extend();

---- 游戏运行模式
function MakeVector3f:new(...)
  MakeVector3f.super.new(self, ...)
end

function MakeVector3f:_OnUpdate(args)
  return mf.vector3(args[1], args[2], args[3]);
end

---- 编辑器模式
MakeVector3f:RegisterInput(1, Types.FloatType, "x", "x 浮点", 0.0);
MakeVector3f:RegisterInput(2, Types.FloatType, "y", "y 浮点", 0.0);
MakeVector3f:RegisterInput(3, Types.FloatType, "z", "z 浮点", 0.0);

MakeVector3f:RegisterOutput(1, mf.vector3:RTTI(), "return vector3f", "创建向量(x,y,z)");

MakeVector3f:SetFunctionName("Make Vector3f");

MakeVector3f:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return MakeVector3f ;