local AE = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local SetParameterNode = require "bluecore.setparameternode"
local RttiOfTE = AE.TextureEntity:RTTI();
local BlueRtti = require "bluecore.core.blue_rtti"
local SetTextureCube = SetParameterNode:extend();
--Unreal Engine: Set Texture Parameter Value
--这里区分Texture类型 TextureEntity的TextureType和Uniform的Texture类型不同不允许赋值

---- 游戏运行模式
function SetTextureCube:new(...)
  SetTextureCube.super.new(self, ...)
  --self.inputs[3].literal = "DEVICE_CAPTURE";
end

function SetTextureCube:_OnUpdate(args)

	local tex = args[3]; 
	local entity = nil;

	if not tex then --连线的输入为空
		self.errorWarning = "nil input texture";
		return;
	elseif type(tex) == "string" then
		-- TODO(hhl) 未来要改成 由字面值对应的叶节点 根据RTTI和字面值(metadata)生成对象
		local filepath = tex
	 	entity = BlueRtti.Create(RttiOfTE, filepath)
	end

	local texture = type(tex) == "string" and entity or tex;


	if texture:RTTI() == AE.RenderTargetEntity:RTTI() then --如果输入为fbo
		local rttex = texture:GetAttachment(AE.RenderTargetEntity.TA_COLOR_0);
		if rttex:GetTextureType() ~= AE.TextureEntity.VT_TEXTURECUBE then
			self.errorWarning = "input texture isnt TEXTURE CUBE";
			return;
		end
	elseif texture:GetTextureType() ~= AE.TextureEntity.VT_TEXTURECUBE then
		self.errorWarning = "input texture isnt TEXTURE CUBE";
		return;
 	end

 	local inputArgs = {args[1], args[2], texture};

 	local paraType = self:GetParameterType(inputArgs);
  self:SetParameter(inputArgs, paraType, AE.MaterialEntity.VT_TEXTURECUBE);

end

--暂时隐藏掉 需要的时候再开启
function SetTextureCube:isHide()
	return true;
end

---- 编辑器模式

SetTextureCube:RegisterInput(1, AE.MaterialEntity:RTTI(), "Material", "材质实体", BlueSelf());
SetTextureCube:RegisterInput(2, Types.StringType, "ParaName", "参数名字", "_MainTex");
SetTextureCube:RegisterInput(3, RttiOfTE, "ParaValue", "参数值", "DEVICE_CAPTURE");
--FIXME(hjh) 给一个hdr素材？
SetTextureCube:RegisterExecInput(1, "exec", "执行");
SetTextureCube:RegisterExecOutput(1, "exec", "执行");
SetTextureCube:SetFunctionName("SetTextureCube");


return SetTextureCube ;

