local AE = require "apollocore"
local Types = require "venuscore.rtti.types"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local Base = require "bluecore.base.overlay_base_regex"
local BeginOverlayRegex = Base:extend();

function BeginOverlayRegex:new(...)
  BeginOverlayRegex.super.new(self, ...)
end

-- unreal will trigger
function BeginOverlayRegex:_OnUpdate(eventParam)

  local otherComp = eventParam.otherComp ;
  local otherNode = eventParam.otherNode ;
  local otherName = eventParam.otherName ;
  local collisionPointInfo = eventParam.collisionPointInfo ;

  local found = string.find(otherName, self.regexString)

  if found == nil then
    self.nextExecIdx = Base.BREAK
    return
  end

  self.nextExecIdx = Base.TRIGGER
  return otherNode, otherComp, collisionPointInfo;
end

function BeginOverlayRegex:_GetType()
  return BD.Event.CollisionEvent.BeginOverlay
end

BeginOverlayRegex:RegisterOutput(1, AE.Node:RTTI(), "node" , "other node")
BeginOverlayRegex:RegisterOutput(2, AE.RigidBodyComponent:RTTI(), "comp", "other component")
BeginOverlayRegex:RegisterOutput(3, BU:GetArrayRtti(Types.CollisionDataType) , "data", "碰撞点和法线");
BeginOverlayRegex:SetFunctionName("Begin Overlay");

return BeginOverlayRegex;
