local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local TwoMeshDistance = BlueNode:extend();

---- 游戏运行模式
function TwoMeshDistance:new(...)
    TwoMeshDistance.super.new(self,...);
end

function TwoMeshDistance:_OnUpdate(args)
    local trans1 = args[1]:GetComponent(apolloengine.Node.CT_TRANSFORM);
    local trans2 = args[2]:GetComponent(apolloengine.Node.CT_TRANSFORM);
    local distvec = trans1:GetWorldPosition() - trans2:GetWorldPosition();
    return distvec:Length();
end


---- 编辑器模式

--在根节点设置子节点active状态实现场景切换
TwoMeshDistance:RegisterInput(1, apolloengine.Node:RTTI(), "mesh1", "模型1", BlueSelf());
TwoMeshDistance:RegisterInput(2, apolloengine.Node:RTTI(), "mesh2", "模型2", BlueSelf());
TwoMeshDistance:RegisterOutput(1, Types.FloatType, "distance", "两个模型的距离");



TwoMeshDistance:SetFunctionName("TwoMeshDistance");

return TwoMeshDistance;