


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local SetWorldScale = BlueNode:extend();

---- 游戏运行模式
function SetWorldScale:new(...)
  SetWorldScale.super.new(self, ...)
end

function SetWorldScale:_OnUpdate(args)
  local transformComponent_target = args[1];
  local vec3f_scale = args[2];
  transformComponent_target:SetWorldScale(vec3f_scale);

  return true;
end



---- 编辑器模式



SetWorldScale:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
SetWorldScale:RegisterInput(2, mathfunction.vector3:RTTI(), "scale", "设置target在世界坐标系下的缩放", mathfunction.vector3(1.0,1.0,1.0));

SetWorldScale:RegisterOutput(1, Types.BoolType, "result", "设置成功返回true");

SetWorldScale:RegisterExecInput(1, "exec", "执行");
SetWorldScale:RegisterExecOutput(1, "exec", "执行");

SetWorldScale:SetFunctionName("SetWorldScale");


return SetWorldScale ;

