
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"


local GetLocalPosition = BlueNode:extend();

---- 游戏运行模式
function GetLocalPosition:new(...)
  GetLocalPosition.super.new(self, ...)
end

function GetLocalPosition:_OnUpdate(args)
  local transformComponent_target = args[1];
  local result = transformComponent_target:GetLocalPosition();
  return result:x(), result:y(), result:z();
end



---- 编辑器模式


GetLocalPosition:RegisterOutput(1, Types.FloatType, "x", "x坐标");
GetLocalPosition:RegisterOutput(2, Types.FloatType, "y", "y坐标");
GetLocalPosition:RegisterOutput(3, Types.FloatType, "z", "z坐标");

GetLocalPosition:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());

GetLocalPosition:SetFunctionName("GetLocalPosition");


return GetLocalPosition ;

