local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local MemberIterator = require "venuscore.rtti.mpairs"
local BlueSelf = require "bluecore.blueself"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local BlueNode = require "bluecore.bluenode"
local venuscore = require "libvenuscore"
local BluePinInfo = require "bluecore.bluepininfo"
local SetScriptValue = BlueNode:extend();


---- 游戏运行模式
function SetScriptValue:new(...)
  SetScriptValue.super.new(self, ...)
end

function SetScriptValue:_SetupInstanceInfoTable()

  -- infoTable 在bluenode不会被序列化出去 
  -- 反射instance为vector3的所有参数作为数据引脚2的枚举选择 需要重写infoTable
  local staticExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  local staticExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]
  local staticDataOutputsInfo = self.infoTable[BD.PIN_DATA_OUTPUT]
  local staticDataInputsInfo = self.infoTable[BD.PIN_DATA_INPUT]
  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = staticDataOutputsInfo -- 并不会动态修改 data output info
  self.infoTable[BD.PIN_EXEC_INPUT]  = staticExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = staticExecOutputsInfo


  self.myUnFixComboType = Types.ClassifyType:extend();
  self.myUnFixComboType:SetData({},{});

  local pinInfo = staticDataInputsInfo[1]
  self.infoTable[BD.PIN_DATA_INPUT][1] =  staticDataInputsInfo[1]
  pinInfo = staticDataInputsInfo[2]
  self.infoTable[BD.PIN_DATA_INPUT][2] = BluePinInfo(BD.PIN_DATA_INPUT, pinInfo.argId, self.myUnFixComboType, pinInfo.name,pinInfo.tips,pinInfo.default,pinInfo.delAble, pinInfo.groupName);
  pinInfo = staticDataInputsInfo[3]
  self.infoTable[BD.PIN_DATA_INPUT][3] =  staticDataInputsInfo[3]

end

function SetScriptValue:_IsRightType(key, value, scriptIns)
  return true;
end

--反序列化恢復菜單
function SetScriptValue:_OnDeserializePost()
  SetScriptValue.super._OnDeserialize(self);
  self:_SetupInstanceInfoTable();
  if next(self.inputs[1].links) ~= nil then
    local bluePinLink = self.inputs[1].links[1] -- 输入引脚只允许一个连接
    local otherNode = self.graph:GetNode(bluePinLink.nodeUid);
    local ktbl = {};
    local vtbl = {};
    if otherNode:GetFunctionType() == BD.COMPONENT_CONTENT_NODE and not venuscore.isNil(otherNode.comp) and otherNode.comp.Instances[otherNode.ins] then
      local ins = otherNode.comp.Instances[otherNode.ins];
      for k,v in MemberIterator(ins) do
        if self:_IsRightType(k, v, ins) then
          table.insert(ktbl, k);
          table.insert(vtbl, k);
        end
      end
      self.myUnFixComboType:SetData(ktbl, vtbl);
    end
  end
  -- body
end




function SetScriptValue:_OnCompile()
  self.compileResult = nil;
  if SetScriptValue.super._OnCompile(self) then
    --Step 1 字符串如果是默认的则直接报错
    if self.inputs[2].literal == BD.EMPTY_STRING then
      self.compileResult = BD.EHINT.ERROR_PARA;
      return false;
    end

    if #self.inputs[1].links ~= 0 then
      local bluePinLink = self.inputs[1].links[1]; -- 输入引脚只允许一个连接
      local otherNode = self.graph:GetNode(bluePinLink.nodeUid);

      -- Step.2 确保上一个节点是 ScriptComponent节点  并且有对应的Instance
      if otherNode:GetFunctionType() == BD.COMPONENT_CONTENT_NODE and otherNode.comp == nil then
        self.compileResult = BD.EHINT.NOT_LINK_TO_COMP;
        return false;
      end

      if venuscore.isNil(otherNode.comp) then
        self.compileResult = BD.EHINT.COMP_LOST;
        return false;
      end

      if not otherNode.comp.Instances[otherNode.ins] then
        self.compileResult = BD.EHINT.INS_NOT_EXIST;
        return false;
      end
    else
      self.compileResult = BD.EHINT.PIN_1_EMPTY;
      return false;
    end

    return true;

  end
  return false; 

end


---------编辑器模式
if _KRATOSEDITOR then


  function SetScriptValue:_OnLink(selfPin, otherNode, otherPin)
    --连线输入了instance时候 更新一下可选枚举
    if otherNode:GetFunctionType() == BD.COMPONENT_CONTENT_NODE and not venuscore.isNil(otherNode.comp) and otherNode.comp.Instances[otherNode.ins] then
      --self.selectTable = {};
      --self.recalllink = selfPin.links[1].linkUid;
      local ins = otherNode.comp.Instances[otherNode.ins];
      local ktbl = {};
      local vtbl = {};
      for k,v in MemberIterator(ins) do
        if self:_IsRightType(k, v, ins) then
          table.insert(ktbl, k);
          table.insert(vtbl, k);
        end
      end
      self.myUnFixComboType:SetData(ktbl, vtbl);
    end
  end

  function SetScriptValue:_OnUnLink(unlinkPin) --这个时候传入pin  里面的link信息已经在blueprint被删了
    if next(self.inputs[1].links) == nil then
      self.myUnFixComboType:SetData({}, {});
      self.inputs[2].literal = BD.EMPTY_STRING;
      --self.recalllink = selfPin.links[1].linkUid;
    end
  end

  function SetScriptValue:_OnCreateWithEditor()
    SetScriptValue.super._OnCreateWithEditor(self);
    self:_SetupInstanceInfoTable();
  end

end


return SetScriptValue ;

