require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

local nasolabial = {}

nasolabial.renderObject = nil;
nasolabial.queue = 100;
nasolabial.mask = nil;
nasolabial.strengh = 0.5;
nasolabial.brightscale = 8;

function nasolabial:Initialize(host, size)
  self.Stepsize1 = mathfunction.vector2(5, 5);
  self.Stepsize2 = mathfunction.vector2(3, 3);
  
  self.GuassStep1 = self.Stepsize1 / size;
  self.GuassStep2 = self.Stepsize2 / size;
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
  
  self.TEXTURE_MASK = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_MASK");
  self.TEXTURE_BLUR1 = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR1");
  self.UNIFORM_STRENGTH = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_STRENGTH");
  self.UNIFORM_BRIGHTSCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_SCALE");
  
    
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  self.GuassXMaterial = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
  self.GuassXRenderObj = host:CreateRenderObject();
  self.GuassXMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0) );
  
  self.GuassYMaterial = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
  self.GuassYRenderObj = host:CreateRenderObject();
  self.GuassYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y()) );
  
  self.BlendMaterial = host:CreateMaterial( "docs:beauty/material/nasolabial.material" );
  self.BlendRenderObj = host:CreateRenderObject();
  self.BlendMaterial:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );
  self.BlendMaterial:SetParameter( self.UNIFORM_BRIGHTSCALE, mathfunction.vector1(self.brightscale) );
  
  self.blurXRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  self.blurRT1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );
  return self.queue;
end

function nasolabial:Resizeview(size)
  self.GuassStep1 = self.Stepsize1 / size;
  self.GuassStep2 = self.Stepsize2 / size;
  self.size = size;
  
end

function nasolabial:Process(context, Original, Scene, Output)
  
  self:_UpdateParameters();
  
  self.GuassXMaterial:SetParameter(self.GAUSSIAN_STEP, mathfunction.vector2( self.GuassStep1:x(), 0) );
  -- self.blurXRT:PushRenderTarget();
	-- self.blurXRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.blurXRT, apolloengine.RenderTargetEntity.CF_COLOR);
	self.GuassXMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
	-- self.GuassX:Draw(pipeline);
  context:Draw(self.GuassXRenderObj,  self.GuassXMaterial);
  context:EndRenderPass();
  
  self.GuassYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, self.GuassStep1:y()) );
  -- self.blurRT1:PushRenderTarget();
  -- self.blurRT1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.blurRT1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.GuassYMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.blurXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  -- self.GuassY:Draw(pipeline);
  context:Draw(self.GuassYRenderObj,  self.GuassYMaterial);
  context:EndRenderPass();
  
  -- Output:PushRenderTarget();
  -- Output:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  
  local blurtexture1 = self.blurRT1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  local origintexture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  self.BlendMaterial:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,origintexture);
  self.BlendMaterial:SetParameter(self.TEXTURE_MASK,self.mask);
  self.BlendMaterial:SetParameter(self.TEXTURE_BLUR1,blurtexture1);
  
  -- self.Blend:Draw(pipeline);
  context:Draw(self.BlendRenderObj,  self.BlendMaterial);
  context:EndRenderPass();
end

function nasolabial:_UpdateParameters()
  LOG("STRENGTH"..self.strengh);
  self.BlendMaterial:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh));
end

return nasolabial;