local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local Mopi = {}
Mopi.DoMaterial = 0;
Mopi.DoRenderObj = 0;
Mopi.Queue = 310;

function Mopi:Initialize(host, size)

    self.sigma_r = mathfunction.vector1(0.3);
   
    self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
            apolloengine.ShaderEntity.UNIFORM,
            "iResolution");
  
    self.SIGMA_R = apolloengine.IMaterialSystem:NewParameterSlot(
            apolloengine.ShaderEntity.UNIFORM,
            "BSIGMA");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/mopi.material");
  self.DoMaterial = host:CreateMaterial(pathout);
  self.DoRenderObj = host:CreateRenderObject();

  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
  self.DoMaterial:SetParameter(self.SIGMA_R, self.sigma_r);
  
  host:RegisterScriptParameter(self,"sigma_r");

  return self.Queue;
end



function Mopi:Resizeview(size)
    self.DoMaterial:SetParameter(self.TARGETSIZE,size);
end

function Mopi:Process(context, Original, Scene, Output)
 
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DoMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.DoMaterial:SetParameter(self.SIGMA_R, self.sigma_r);
  context:Draw(self.DoRenderObj, self.DoMaterial);
  context:EndRenderPass();
end

return Mopi;